/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.batch.core.JobParameters;
import org.springframework.util.Assert;

public class JobParametersBuilder {
    private final Map stringMap = new LinkedHashMap();
    private final Map longMap = new LinkedHashMap();
    private final Map doubleMap = new LinkedHashMap();
    private final Map dateMap = new LinkedHashMap();

    public JobParametersBuilder addString(String key, String parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null.");
        this.stringMap.put(key, parameter);
        return this;
    }

    public JobParametersBuilder addDate(String key, Date parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null.");
        this.dateMap.put(key, new Date(parameter.getTime()));
        return this;
    }

    public JobParametersBuilder addLong(String key, Long parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null.");
        this.longMap.put(key, parameter);
        return this;
    }

    public JobParametersBuilder addDouble(String key, Double parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null.");
        this.doubleMap.put(key, parameter);
        return this;
    }

    public JobParameters toJobParameters() {
        return new JobParameters(this.stringMap, this.longMap, this.doubleMap, this.dateMap);
    }
}

