/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class SimpleJobLauncher
implements JobLauncher,
InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)SimpleJobLauncher.class);
    private JobRepository jobRepository;
    private TaskExecutor taskExecutor;

    public JobExecution run(final Job job, final JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Assert.notNull((Object)job, (String)"The Job must not be null.");
        Assert.notNull((Object)jobParameters, (String)"The JobParameters must not be null.");
        final JobExecution jobExecution = this.jobRepository.createJobExecution(job, jobParameters);
        this.taskExecutor.execute(new Runnable(){

            public void run() {
                try {
                    logger.info((Object)("Job: [" + job + "] launched with the following parameters: [" + jobParameters + "]"));
                    job.execute(jobExecution);
                    logger.info((Object)("Job: [" + job + "] completed successfully with the following parameters: [" + jobParameters + "]"));
                }
                catch (Throwable t) {
                    logger.info((Object)("Job: [" + job + "] failed with the following parameters: [" + jobParameters + "]"), t);
                    this.rethrow(t);
                }
            }

            private void rethrow(Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        });
        return jobExecution;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobRepository != null ? 1 : 0) != 0, (String)"A JobRepository has not been set.");
        if (this.taskExecutor == null) {
            logger.info((Object)"No TaskExecutor has been set, defaulting to synchronous executor.");
            this.taskExecutor = new SyncTaskExecutor();
        }
    }
}

