/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.listener.OrderedComposite;
import org.springframework.batch.repeat.ExitStatus;

public class CompositeStepExecutionListener
implements StepExecutionListener {
    private OrderedComposite list = new OrderedComposite();

    public void setListeners(StepExecutionListener[] listeners) {
        this.list.setItems(listeners);
    }

    public void register(StepExecutionListener stepExecutionListener) {
        this.list.add(stepExecutionListener);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = null;
        Iterator iterator = this.list.reverse();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            ExitStatus close = listener.afterStep(stepExecution);
            status = status != null ? status.and(close) : close;
        }
        return status;
    }

    public void beforeStep(StepExecution stepExecution) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            listener.beforeStep(stepExecution);
        }
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        ExitStatus status = null;
        Iterator iterator = this.list.reverse();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            ExitStatus close = listener.onErrorInStep(stepExecution, e);
            status = status != null ? status.and(close) : close;
        }
        return status;
    }
}

