/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.util.Assert;

public class MapJobExecutionDao
implements JobExecutionDao {
    private static Map executionsById = TransactionAwareProxyFactory.createTransactionalMap();
    private static Map contextsByJobExecutionId = TransactionAwareProxyFactory.createTransactionalMap();
    private static long currentId = 0L;

    public static void clear() {
        executionsById.clear();
        contextsByJobExecutionId.clear();
    }

    private static final JobExecution copy(JobExecution original) {
        return (JobExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)original));
    }

    private static final ExecutionContext copy(ExecutionContext original) {
        return (ExecutionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)original));
    }

    public int getJobExecutionCount(JobInstance jobInstance) {
        int count = 0;
        Iterator iterator = executionsById.values().iterator();
        while (iterator.hasNext()) {
            JobExecution exec = (JobExecution)iterator.next();
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            ++count;
        }
        return count;
    }

    public void saveJobExecution(JobExecution jobExecution) {
        Assert.isTrue((jobExecution.getId() == null ? 1 : 0) != 0);
        Long newId = new Long(currentId++);
        jobExecution.setId(newId);
        jobExecution.incrementVersion();
        executionsById.put(newId, MapJobExecutionDao.copy(jobExecution));
    }

    public List findJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        Iterator iterator = executionsById.values().iterator();
        while (iterator.hasNext()) {
            JobExecution exec = (JobExecution)iterator.next();
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            executions.add(MapJobExecutionDao.copy(exec));
        }
        return executions;
    }

    public void updateJobExecution(JobExecution jobExecution) {
        Long id = jobExecution.getId();
        Assert.notNull((Object)id, (String)"JobExecution is expected to have an id (should be saved already)");
        Assert.notNull(executionsById.get(id), (String)"JobExecution must already be saved");
        jobExecution.incrementVersion();
        executionsById.put(id, MapJobExecutionDao.copy(jobExecution));
    }

    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        JobExecution lastExec = null;
        Iterator iterator = executionsById.values().iterator();
        while (iterator.hasNext()) {
            JobExecution exec = (JobExecution)iterator.next();
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            if (lastExec == null) {
                lastExec = exec;
            }
            if (!lastExec.getCreateTime().before(exec.getCreateTime())) continue;
            lastExec = exec;
        }
        if (lastExec == null) {
            return null;
        }
        return MapJobExecutionDao.copy(lastExec);
    }

    public ExecutionContext findExecutionContext(JobExecution jobExecution) {
        return MapJobExecutionDao.copy((ExecutionContext)contextsByJobExecutionId.get(jobExecution.getId()));
    }

    public void saveOrUpdateExecutionContext(JobExecution jobExecution) {
        contextsByJobExecutionId.put(jobExecution.getId(), MapJobExecutionDao.copy(jobExecution.getExecutionContext()));
    }
}

