/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class SimpleJobRepository
implements JobRepository {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;

    SimpleJobRepository() {
    }

    public SimpleJobRepository(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
    }

    public JobExecution createJobExecution(Job job, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ExecutionContext executionContext;
        Assert.notNull((Object)job, (String)"Job must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(job, jobParameters);
        if (jobInstance != null) {
            if (!job.isRestartable()) {
                throw new JobRestartException("JobInstance already exists and is not restartable");
            }
            List executions = this.jobExecutionDao.findJobExecutions(jobInstance);
            Iterator iterator = executions.iterator();
            while (iterator.hasNext()) {
                JobExecution execution = (JobExecution)iterator.next();
                if (execution.isRunning()) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobInstance);
                }
                if (execution.getStatus() != BatchStatus.COMPLETED) continue;
                throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + jobParameters + ".  If you want to run this job again, change the parameters.");
            }
            executionContext = this.jobExecutionDao.getLastJobExecution(jobInstance).getExecutionContext();
        } else {
            jobInstance = this.jobInstanceDao.createJobInstance(job, jobParameters);
            executionContext = new ExecutionContext();
        }
        JobExecution jobExecution = new JobExecution(jobInstance);
        jobExecution.setExecutionContext(executionContext);
        this.saveOrUpdate(jobExecution);
        return jobExecution;
    }

    public void saveOrUpdate(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"JobExecution cannot be null.");
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution must have a Job ID set.");
        if (jobExecution.getId() == null) {
            this.jobExecutionDao.saveJobExecution(jobExecution);
        } else {
            this.jobExecutionDao.updateJobExecution(jobExecution);
        }
    }

    public void saveOrUpdate(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"StepExecution cannot be null.");
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution's step name cannot be null.");
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"StepExecution must belong to persisted JobExecution");
        if (stepExecution.getId() == null) {
            this.stepExecutionDao.saveStepExecution(stepExecution);
        } else {
            this.stepExecutionDao.updateStepExecution(stepExecution);
        }
    }

    public void saveOrUpdateExecutionContext(StepExecution stepExecution) {
        this.stepExecutionDao.saveOrUpdateExecutionContext(stepExecution);
        this.jobExecutionDao.saveOrUpdateExecutionContext(stepExecution.getJobExecution());
    }

    public StepExecution getLastStepExecution(JobInstance jobInstance, Step step) {
        StepExecution stepExecution;
        List jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>(jobExecutions.size());
        Iterator iterator = jobExecutions.iterator();
        while (iterator.hasNext()) {
            JobExecution jobExecution = (JobExecution)iterator.next();
            stepExecution = this.stepExecutionDao.getStepExecution(jobExecution, step);
            if (stepExecution == null) continue;
            stepExecutions.add(stepExecution);
        }
        StepExecution latest = null;
        Iterator iterator2 = stepExecutions.iterator();
        while (iterator2.hasNext()) {
            stepExecution = (StepExecution)iterator2.next();
            if (latest == null) {
                latest = stepExecution;
            }
            if (latest.getStartTime().getTime() >= stepExecution.getStartTime().getTime()) continue;
            latest = stepExecution;
        }
        return latest;
    }

    public int getStepExecutionCount(JobInstance jobInstance, Step step) {
        int count = 0;
        List jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        Iterator iterator = jobExecutions.iterator();
        while (iterator.hasNext()) {
            JobExecution jobExecution = (JobExecution)iterator.next();
            if (this.stepExecutionDao.getStepExecution(jobExecution, step) == null) continue;
            ++count;
        }
        return count;
    }
}

