/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class JobParameter
implements Serializable {
    private final Object parameter;
    private final ParameterType parameterType;

    public JobParameter(String parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.STRING;
    }

    public JobParameter(Long parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.LONG;
    }

    public JobParameter(Date parameter) {
        this.parameter = new Date(parameter.getTime());
        this.parameterType = ParameterType.DATE;
    }

    public JobParameter(Double parameter) {
        this.parameter = parameter;
        this.parameterType = ParameterType.DOUBLE;
    }

    public Object getValue() {
        if (this.parameter.getClass().isInstance(Date.class)) {
            return new Date(((Date)this.parameter).getTime());
        }
        return this.parameter;
    }

    public ParameterType getType() {
        return this.parameterType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JobParameter rhs = (JobParameter)obj;
        return this.parameter.equals(rhs.parameter);
    }

    public String toString() {
        return this.parameterType == ParameterType.DATE ? "" + ((Date)this.parameter).getTime() : this.parameter.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 21).append(this.parameter).toHashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParameterType {
        STRING,
        DATE,
        LONG,
        DOUBLE;

    }
}

