/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.batch.core.configuration.util.MethodInvoker;
import org.springframework.batch.core.configuration.util.SimpleMethodInvoker;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokerUtils {
    public static MethodInvoker createMethodInvokerByName(Object object, String methodName, boolean paramsRequired, Class<?> ... paramTypes) {
        Assert.notNull((Object)object, (String)"Object to invoke must not be null");
        Method method = ClassUtils.getMethodIfAvailable(object.getClass(), (String)methodName, (Class[])paramTypes);
        if (method == null && !paramsRequired) {
            method = ClassUtils.getMethodIfAvailable(object.getClass(), (String)methodName, (Class[])new Class[0]);
        }
        if (method == null) {
            return null;
        }
        return new SimpleMethodInvoker(object, method);
    }

    public static MethodInvoker getMethodInvokerForInterface(Class<?> iFace, String methodName, Object object, Class<?> ... paramTypes) {
        if (iFace.isAssignableFrom(object.getClass())) {
            return MethodInvokerUtils.createMethodInvokerByName(object, methodName, true, paramTypes);
        }
        return null;
    }

    public static MethodInvoker getMethodInvokerByAnnotation(final Class<? extends Annotation> annotationType, final Object candidate) {
        Assert.notNull((Object)candidate, (String)"class must not be null");
        Assert.notNull(annotationType, (String)"annotationType must not be null");
        Assert.isTrue((boolean)ObjectUtils.containsElement((Object[])annotationType.getAnnotation(Target.class).value(), (Object)((Object)ElementType.METHOD)), (String)("Annotation [" + annotationType + "] is not a Method-level annotation."));
        final AtomicReference annotatedMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(candidate.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Annotation annotation = AnnotationUtils.findAnnotation((Method)method, (Class)annotationType);
                if (annotation != null) {
                    Assert.isNull(annotatedMethod.get(), (String)("found more than one method on target class [" + candidate + "] with the annotation type [" + candidate + "]"));
                    annotatedMethod.set(method);
                }
            }
        });
        Method method = (Method)annotatedMethod.get();
        if (method == null) {
            return null;
        }
        return new SimpleMethodInvoker(candidate, (Method)annotatedMethod.get());
    }
}

