/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.batch.core.configuration.util.MethodInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMethodInvoker
implements MethodInvoker {
    private final Object object;
    private Method method;

    public SimpleMethodInvoker(Object object, Method method) {
        Assert.notNull((Object)object, (String)"Object to invoke must not be null");
        Assert.notNull((Object)method, (String)"Method to invoke must not be null");
        this.object = object;
        this.method = method;
    }

    public SimpleMethodInvoker(Object object, String methodName, Class<?> ... paramTypes) {
        Assert.notNull((Object)object, (String)"Object to invoke must not be null");
        this.object = object;
        this.method = ClassUtils.getMethodIfAvailable(object.getClass(), (String)methodName, (Class[])paramTypes);
        if (this.method == null) {
            this.method = ClassUtils.getMethodIfAvailable(object.getClass(), (String)methodName, (Class[])new Class[0]);
        }
        if (this.method == null) {
            throw new IllegalArgumentException("No methods found for name: [" + methodName + "] in class: [" + object.getClass() + "] with arguments of type: [" + Arrays.toString(paramTypes) + "]");
        }
    }

    @Override
    public Object invokeMethod(Object ... args) {
        Object[] invokeArgs;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length == 0) {
            invokeArgs = new Object[]{};
        } else {
            if (parameterTypes.length > args.length) {
                throw new IllegalArgumentException("Wrong number of arguments, expected no more than: [" + parameterTypes.length + "]");
            }
            invokeArgs = args;
        }
        this.method.setAccessible(true);
        try {
            return this.method.invoke(this.object, invokeArgs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to invoke method: [" + this.method + "] on object: [" + this.object + "] with arguments: [" + Arrays.toString(args) + "]");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleMethodInvoker)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SimpleMethodInvoker rhs = (SimpleMethodInvoker)obj;
        return rhs.method.equals(this.method) && rhs.object.equals(this.object);
    }

    public int hashCode() {
        return new HashCodeBuilder(25, 37).append(this.object.hashCode()).append(this.method.hashCode()).toHashCode();
    }
}

