/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.configuration.xml.TaskletElementParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStepParser {
    TaskletElementParser taskletElementParser = new TaskletElementParser();

    protected AbstractBeanDefinition parseTaskletRef(Element stepElement, String taskletRef, ParserContext parserContext, String jobRepositoryRef) {
        RootBeanDefinition bd = new RootBeanDefinition("org.springframework.batch.core.step.tasklet.TaskletStep", null, null);
        if (StringUtils.hasText((String)taskletRef)) {
            RuntimeBeanReference taskletBeanRef = new RuntimeBeanReference(taskletRef);
            bd.getPropertyValues().addPropertyValue("tasklet", (Object)taskletBeanRef);
        }
        this.checkStepAttributes(stepElement, (AbstractBeanDefinition)bd);
        RuntimeBeanReference jobRepositoryBeanRef = new RuntimeBeanReference(jobRepositoryRef);
        bd.getPropertyValues().addPropertyValue("jobRepository", (Object)jobRepositoryBeanRef);
        String transactionManagerRef = stepElement.getAttribute("transaction-manager");
        RuntimeBeanReference transactionManagerBeanRef = new RuntimeBeanReference(transactionManagerRef);
        bd.getPropertyValues().addPropertyValue("transactionManager", (Object)transactionManagerBeanRef);
        this.handleListenersElement(stepElement, (BeanDefinition)bd, parserContext, "stepExecutionListeners");
        bd.setRole(1);
        bd.setSource(parserContext.extractSource((Object)stepElement));
        return bd;
    }

    protected AbstractBeanDefinition parseTaskletElement(Element stepElement, Element element, ParserContext parserContext, String jobRepositoryRef) {
        AbstractBeanDefinition bd = this.taskletElementParser.parseTaskletElement(element, parserContext);
        this.checkStepAttributes(stepElement, bd);
        RuntimeBeanReference jobRepositoryBeanRef = new RuntimeBeanReference(jobRepositoryRef);
        bd.getPropertyValues().addPropertyValue("jobRepository", (Object)jobRepositoryBeanRef);
        String transactionManagerRef = stepElement.getAttribute("transaction-manager");
        RuntimeBeanReference tx = new RuntimeBeanReference(transactionManagerRef);
        bd.getPropertyValues().addPropertyValue("transactionManager", (Object)tx);
        this.handleListenersElement(stepElement, (BeanDefinition)bd, parserContext, "listeners");
        bd.setRole(1);
        bd.setSource(parserContext.extractSource((Object)stepElement));
        return bd;
    }

    private void checkStepAttributes(Element stepElement, AbstractBeanDefinition bd) {
        String allowStartIfComplete;
        String startLimit = stepElement.getAttribute("start-limit");
        if (StringUtils.hasText((String)startLimit)) {
            bd.getPropertyValues().addPropertyValue("startLimit", (Object)startLimit);
        }
        if (StringUtils.hasText((String)(allowStartIfComplete = stepElement.getAttribute("allow-start-if-complete")))) {
            bd.getPropertyValues().addPropertyValue("allowStartIfComplete", (Object)allowStartIfComplete);
        }
    }

    private void handleListenersElement(Element element, BeanDefinition bd, ParserContext parserContext, String property) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"listeners");
        if (listenersElement != null) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ArrayList<Object> listenerBeans = new ArrayList<Object>();
            this.handleStepListenerElements(parserContext, listenersElement, listenerBeans);
            ManagedList arguments = new ManagedList();
            arguments.addAll(listenerBeans);
            bd.getPropertyValues().addPropertyValue(property, (Object)arguments);
            parserContext.popAndRegisterContainingComponent();
        }
    }

    private void handleStepListenerElements(ParserContext parserContext, Element element, List<Object> beans) {
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (listenerElements != null) {
            for (Element listenerElement : listenerElements) {
                String[] methodNameAttributes;
                BeanDefinitionBuilder listenerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.listener.StepListenerFactoryBean");
                String id = listenerElement.getAttribute("id");
                String listenerRef = listenerElement.getAttribute("ref");
                String className = listenerElement.getAttribute("class");
                this.checkListenerElementAttributes(parserContext, element, listenerElement, id, listenerRef, className);
                if (StringUtils.hasText((String)listenerRef)) {
                    listenerBuilder.addPropertyReference("delegate", listenerRef);
                } else if (StringUtils.hasText((String)className)) {
                    RootBeanDefinition beanDef = new RootBeanDefinition(className, null, null);
                    listenerBuilder.addPropertyValue("delegate", (Object)beanDef);
                } else {
                    parserContext.getReaderContext().error("Neither 'ref' or 'class' specified for <" + listenerElement.getTagName() + "> element", (Object)element);
                }
                ManagedMap metaDataMap = new ManagedMap();
                for (String metaDataPropertyName : methodNameAttributes = new String[]{"before-step-method", "after-step-method", "before-chunk-method", "after-chunk-method", "before-read-method", "after-read-method", "on-read-error-method", "before-process-method", "after-process-method", "on-process-error-method", "before-write-method", "after-write-method", "on-write-error-method", "on-skip-in-read-method", "on-skip-in-process-method", "on-skip-in-write-method"}) {
                    String listenerMethod = listenerElement.getAttribute(metaDataPropertyName);
                    if (!StringUtils.hasText((String)listenerMethod)) continue;
                    metaDataMap.put((Object)metaDataPropertyName, (Object)listenerMethod);
                }
                listenerBuilder.addPropertyValue("metaDataMap", (Object)metaDataMap);
                AbstractBeanDefinition beanDef = listenerBuilder.getBeanDefinition();
                if (!StringUtils.hasText((String)id)) {
                    id = parserContext.getReaderContext().generateBeanName((BeanDefinition)beanDef);
                }
                beans.add(beanDef);
            }
        }
    }

    private void checkListenerElementAttributes(ParserContext parserContext, Element element, Element listenerElement, String id, String listenerRef, String className) {
        if ((StringUtils.hasText((String)id) || StringUtils.hasText((String)className)) && StringUtils.hasText((String)listenerRef)) {
            NamedNodeMap attributeNodes = listenerElement.getAttributes();
            StringBuilder attributes = new StringBuilder();
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                if (i > 0) {
                    attributes.append(" ");
                }
                attributes.append(attributeNodes.item(i));
            }
            parserContext.getReaderContext().error("Both 'ref' and " + (StringUtils.hasText((String)id) ? "'id'" : "'class'") + " specified; use 'class' with an optional 'id' or just 'ref' for <" + listenerElement.getTagName() + "> element specified with attributes: " + attributes, (Object)element);
        }
    }
}

