/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;

public class CoreNamespaceUtils {
    public static final String STEP_SCOPE_PROCESSOR_BEAN_NAME = "org.springframework.batch.core.scope.internalStepScope";
    public static final String STEP_SCOPE_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.scope.StepScope";

    protected static void checkForStepScope(ParserContext parserContext, Object source) {
        String[] beanNames;
        boolean foundStepScope = false;
        for (String beanName : beanNames = parserContext.getRegistry().getBeanDefinitionNames()) {
            BeanDefinition bd = parserContext.getRegistry().getBeanDefinition(beanName);
            if (!STEP_SCOPE_PROCESSOR_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            foundStepScope = true;
            break;
        }
        if (!foundStepScope) {
            BeanDefinitionBuilder stepScopeBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)STEP_SCOPE_PROCESSOR_CLASS_NAME);
            AbstractBeanDefinition abd = stepScopeBuilder.getBeanDefinition();
            abd.setRole(2);
            abd.setSource(source);
            parserContext.getRegistry().registerBeanDefinition(STEP_SCOPE_PROCESSOR_BEAN_NAME, (BeanDefinition)abd);
        }
    }
}

