/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.DecisionParser;
import org.springframework.batch.core.configuration.xml.InlineStepParser;
import org.springframework.batch.core.configuration.xml.SplitParser;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowParser
extends AbstractSingleBeanDefinitionParser {
    private static final String NEXT = "next";
    private static final String END = "end";
    private static final String FAIL = "fail";
    private static final String STOP = "stop";
    private static int endCounter = 0;
    private final String flowName;
    private final String jobRepositoryRef;

    public FlowParser(String flowName, String jobRepositoryRef) {
        this.flowName = flowName;
        this.jobRepositoryRef = jobRepositoryRef;
    }

    protected Class<SimpleFlow> getBeanClass(Element element) {
        return SimpleFlow.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ArrayList<BeanDefinition> stateTransitions = new ArrayList<BeanDefinition>();
        InlineStepParser stepParser = new InlineStepParser();
        DecisionParser decisionParser = new DecisionParser();
        SplitParser splitParser = new SplitParser(this.jobRepositoryRef);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getLocalName();
            if (nodeName.equals("step")) {
                stateTransitions.addAll(stepParser.parse((Element)node, parserContext, this.jobRepositoryRef));
                continue;
            }
            if (nodeName.equals("decision")) {
                stateTransitions.addAll(decisionParser.parse((Element)node, parserContext));
                continue;
            }
            if (!nodeName.equals("split")) continue;
            stateTransitions.addAll(splitParser.parse((Element)node, new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), (BeanDefinition)builder.getBeanDefinition())));
        }
        builder.addConstructorArgValue((Object)this.flowName);
        ManagedList managedList = new ManagedList();
        boolean dummy = managedList.addAll(stateTransitions);
        builder.addPropertyValue("stateTransitions", (Object)managedList);
        builder.setRole(2);
        parserContext.popAndRegisterContainingComponent();
    }

    protected static Collection<BeanDefinition> getNextElements(ParserContext parserContext, BeanDefinition stateDef, Element element) {
        return FlowParser.getNextElements(parserContext, null, stateDef, element);
    }

    protected static Collection<BeanDefinition> getNextElements(ParserContext parserContext, String stepId, BeanDefinition stateDef, Element element) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        String shortNextAttribute = element.getAttribute(NEXT);
        boolean hasNextAttribute = StringUtils.hasText((String)shortNextAttribute);
        if (hasNextAttribute) {
            list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, null, shortNextAttribute));
        }
        boolean transitionElementExists = false;
        ArrayList<String> patterns = new ArrayList<String>();
        for (String transitionName : new String[]{NEXT, STOP, END, FAIL}) {
            List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)transitionName);
            for (Element transitionElement : transitionElements) {
                FlowParser.verifyUniquePattern(transitionElement, patterns, element, parserContext);
                list.addAll(FlowParser.parseTransitionElement(transitionElement, stepId, stateDef, parserContext));
                transitionElementExists = true;
            }
        }
        if (!transitionElementExists) {
            list.addAll(FlowParser.createTransition(FlowExecutionStatus.FAILED, FlowExecutionStatus.FAILED.getName(), null, null, stateDef, parserContext, false));
            if (!hasNextAttribute) {
                list.addAll(FlowParser.createTransition(FlowExecutionStatus.COMPLETED, null, null, null, stateDef, parserContext, false));
            }
        } else if (hasNextAttribute) {
            parserContext.getReaderContext().error("Step may not contain a 'next' attribute and a transition element", (Object)element);
        }
        return list;
    }

    private static void verifyUniquePattern(Element transitionElement, List<String> patterns, Element element, ParserContext parserContext) {
        String onAttribute = transitionElement.getAttribute("on");
        if (patterns.contains(onAttribute)) {
            parserContext.getReaderContext().error("Duplicate transition pattern found for '" + onAttribute + "'", (Object)element);
        }
        patterns.add(onAttribute);
    }

    private static Collection<BeanDefinition> parseTransitionElement(Element transitionElement, String stateId, BeanDefinition stateDef, ParserContext parserContext) {
        FlowExecutionStatus status = FlowParser.getBatchStatusFromEndTransitionName(transitionElement.getNodeName());
        String onAttribute = transitionElement.getAttribute("on");
        String nextAttribute = transitionElement.getAttribute("to");
        String restartAttribute = transitionElement.getAttribute("restart");
        nextAttribute = StringUtils.hasText((String)nextAttribute) ? nextAttribute : restartAttribute;
        boolean abandon = false;
        if (stateId != null && StringUtils.hasText((String)restartAttribute) && !restartAttribute.equals(stateId)) {
            abandon = true;
        }
        String exitCodeAttribute = transitionElement.getAttribute("exit-code");
        return FlowParser.createTransition(status, onAttribute, nextAttribute, exitCodeAttribute, stateDef, parserContext, abandon);
    }

    private static Collection<BeanDefinition> createTransition(FlowExecutionStatus status, String on, String next, String exitCode, BeanDefinition stateDef, ParserContext parserContext, boolean abandon) {
        BeanDefinition endState = null;
        if (status == FlowExecutionStatus.STOPPED || status == FlowExecutionStatus.COMPLETED || status == FlowExecutionStatus.FAILED) {
            BeanDefinitionBuilder endBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.EndState");
            boolean exitCodeExists = StringUtils.hasText((String)exitCode);
            if (exitCodeExists && !exitCode.startsWith(status.getName())) {
                exitCode = status.getName() + (exitCode.contains(" ") ? " " : "_") + exitCode;
            }
            endBuilder.addConstructorArgValue((Object)(exitCodeExists ? new FlowExecutionStatus(exitCode) : status));
            String endName = (status == FlowExecutionStatus.STOPPED ? STOP : (status == FlowExecutionStatus.FAILED ? FAIL : END)) + endCounter++;
            endBuilder.addConstructorArgValue((Object)endName);
            endBuilder.addConstructorArgValue((Object)abandon);
            String nextOnEnd = exitCodeExists ? null : next;
            endState = FlowParser.getStateTransitionReference(parserContext, (BeanDefinition)endBuilder.getBeanDefinition(), null, nextOnEnd);
            next = endName;
        }
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, on, next));
        if (endState != null) {
            list.add(endState);
        }
        return list;
    }

    private static FlowExecutionStatus getBatchStatusFromEndTransitionName(String elementName) {
        if (STOP.equals(elementName)) {
            return FlowExecutionStatus.STOPPED;
        }
        if (END.equals(elementName)) {
            return FlowExecutionStatus.COMPLETED;
        }
        if (FAIL.equals(elementName)) {
            return FlowExecutionStatus.FAILED;
        }
        return FlowExecutionStatus.UNKNOWN;
    }

    public static BeanDefinition getStateTransitionReference(ParserContext parserContext, BeanDefinition stateDefinition, String on, String next) {
        BeanDefinitionBuilder nextBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.StateTransition");
        nextBuilder.addConstructorArgValue((Object)stateDefinition);
        if (StringUtils.hasText((String)on)) {
            nextBuilder.addConstructorArgValue((Object)on);
        }
        if (StringUtils.hasText((String)next)) {
            nextBuilder.setFactoryMethod("createStateTransition");
            nextBuilder.addConstructorArgValue((Object)next);
        } else {
            nextBuilder.setFactoryMethod("createEndStateTransition");
        }
        return nextBuilder.getBeanDefinition();
    }
}

