/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.AbstractStepParser;
import org.springframework.batch.core.configuration.xml.FlowParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineStepParser
extends AbstractStepParser {
    public Collection<BeanDefinition> parse(Element element, ParserContext parserContext, String jobRepositoryRef) {
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.StepState");
        String stepId = element.getAttribute("id");
        String stepRef = element.getAttribute("ref");
        String taskletRef = element.getAttribute("tasklet");
        List listOfTaskElements = DomUtils.getChildElementsByTagName((Element)element, (String)"tasklet");
        List listOfListenersElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listeners");
        if (StringUtils.hasText((String)stepRef)) {
            if (StringUtils.hasText((String)taskletRef)) {
                parserContext.getReaderContext().error("The 'tasklet' attribute can't be combined with the 'ref=\"" + stepRef + "\"' attribute specification for <" + element.getNodeName() + ">", (Object)element);
            }
            if (listOfTaskElements.size() > 0) {
                parserContext.getReaderContext().error("The <" + ((Element)listOfTaskElements.get(0)).getNodeName() + "> element can't be combined with the 'ref=\"" + stepRef + "\"' attribute specification for <" + element.getNodeName() + ">", (Object)element);
            }
            if (listOfListenersElements.size() > 0) {
                parserContext.getReaderContext().error("The 'listeners' element can't be combined with the 'ref=\"" + stepRef + "\"' attribute specification for <" + element.getNodeName() + ">", (Object)element);
            }
            BeanDefinitionBuilder stepBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.configuration.xml.DelegatingStep");
            stepBuilder.addConstructorArgValue((Object)stepId);
            stepBuilder.addConstructorArgReference(stepRef);
            AbstractBeanDefinition bd = stepBuilder.getBeanDefinition();
            bd.setSource(parserContext.extractSource((Object)element));
            parserContext.getRegistry().registerBeanDefinition(stepId, (BeanDefinition)bd);
            stateBuilder.addConstructorArgReference(stepId);
        } else if (StringUtils.hasText((String)taskletRef)) {
            if (listOfTaskElements.size() > 0) {
                parserContext.getReaderContext().error("The <" + ((Element)listOfTaskElements.get(0)).getNodeName() + "> element can't be combined with the 'tasklet=\"" + taskletRef + "\"' attribute specification for <" + element.getNodeName() + ">", (Object)element);
            }
            AbstractBeanDefinition bd = this.parseTaskletRef(element, taskletRef, parserContext, jobRepositoryRef);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bd, stepId));
            stateBuilder.addConstructorArgReference(stepId);
        } else if (listOfTaskElements.size() > 0) {
            Element taskElement = (Element)listOfTaskElements.get(0);
            AbstractBeanDefinition bd = this.parseTaskletElement(element, taskElement, parserContext, jobRepositoryRef);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bd, stepId));
            stateBuilder.addConstructorArgReference(stepId);
        } else {
            parserContext.getReaderContext().error("Incomplete configuration detected while creating step with name " + stepRef, (Object)element);
        }
        return FlowParser.getNextElements(parserContext, stepId, (BeanDefinition)stateBuilder.getBeanDefinition(), element);
    }
}

