/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class JobExecutionListenerParser {
    public ManagedList parse(Element element, ParserContext parserContext) {
        ArrayList<AbstractBeanDefinition> listeners = new ArrayList<AbstractBeanDefinition>();
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        for (Element listenerElement : listenerElements) {
            BeanDefinitionBuilder listenerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.listener.JobListenerFactoryBean");
            String id = listenerElement.getAttribute("id");
            String listenerRef = listenerElement.getAttribute("ref");
            String className = listenerElement.getAttribute("class");
            if ((StringUtils.hasText((String)id) || StringUtils.hasText((String)className)) && StringUtils.hasText((String)listenerRef)) {
                NamedNodeMap attributeNodes = listenerElement.getAttributes();
                StringBuilder attributes = new StringBuilder();
                for (int i = 0; i < attributeNodes.getLength(); ++i) {
                    if (i > 0) {
                        attributes.append(" ");
                    }
                    attributes.append(attributeNodes.item(i));
                }
                parserContext.getReaderContext().error("Both 'ref' and 'class' specified; use 'class' with an optional 'id' or just 'ref' for <" + listenerElement.getTagName() + "> element with attributes: " + attributes, (Object)listenerElement);
            }
            if (StringUtils.hasText((String)listenerRef)) {
                listenerBuilder.addPropertyReference("delegate", listenerRef);
            } else if (StringUtils.hasText((String)className)) {
                RootBeanDefinition beanDef = new RootBeanDefinition(className, null, null);
                listenerBuilder.addPropertyValue("delegate", (Object)beanDef);
            } else {
                parserContext.getReaderContext().error("Neither 'ref' or 'class' specified for <" + listenerElement.getTagName() + "> element", (Object)listenerElement);
            }
            ManagedMap metaDataMap = new ManagedMap();
            String beforeMethod = listenerElement.getAttribute("before-method");
            if (StringUtils.hasText((String)beforeMethod)) {
                metaDataMap.put((Object)"beforeMethod", (Object)beforeMethod);
            }
            String afterMethod = listenerElement.getAttribute("after-method");
            if (StringUtils.hasText((String)beforeMethod)) {
                metaDataMap.put((Object)"afterMethod", (Object)afterMethod);
            }
            listenerBuilder.addPropertyValue("metaDataMap", (Object)metaDataMap);
            AbstractBeanDefinition beanDef = listenerBuilder.getBeanDefinition();
            listeners.add(beanDef);
        }
        ManagedList managedList = new ManagedList();
        managedList.addAll(listeners);
        return managedList;
    }
}

