/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.FlowParser;
import org.springframework.batch.core.configuration.xml.JobExecutionListenerParser;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<FlowJob> getBeanClass(Element element) {
        return FlowJob.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String incrementer;
        CoreNamespaceUtils.checkForStepScope(parserContext, parserContext.extractSource((Object)element));
        String jobName = element.getAttribute("id");
        builder.addConstructorArgValue((Object)jobName);
        String repositoryAttribute = element.getAttribute("job-repository");
        if (!StringUtils.hasText((String)repositoryAttribute)) {
            repositoryAttribute = "jobRepository";
        }
        builder.addPropertyReference("jobRepository", repositoryAttribute);
        String restartableAttribute = element.getAttribute("restartable");
        if (StringUtils.hasText((String)restartableAttribute)) {
            builder.addPropertyValue("restartable", (Object)restartableAttribute);
        }
        if (StringUtils.hasText((String)(incrementer = element.getAttribute("incrementer")))) {
            builder.addPropertyReference("jobParametersIncrementer", incrementer);
        }
        FlowParser flowParser = new FlowParser(jobName, repositoryAttribute);
        BeanDefinition flowDef = flowParser.parse(element, parserContext);
        builder.addPropertyValue("flow", (Object)flowDef);
        JobExecutionListenerParser listenerParser = new JobExecutionListenerParser();
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"listeners");
        if (listenersElement != null) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList managedList = listenerParser.parse(listenersElement, parserContext);
            builder.addPropertyValue("jobExecutionListeners", (Object)managedList);
            parserContext.popAndRegisterContainingComponent();
        }
    }
}

