/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.FlowParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitParser {
    private final String jobRepositoryRef;

    public SplitParser(String jobRepositoryRef) {
        this.jobRepositoryRef = jobRepositoryRef;
    }

    public Collection<BeanDefinition> parse(Element element, ParserContext parserContext) {
        String idAttribute = element.getAttribute("id");
        List flowElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow");
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.SplitState");
        String taskExecutorBeanId = element.getAttribute("task-executor");
        if (StringUtils.hasText((String)taskExecutorBeanId)) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            stateBuilder.addPropertyValue("taskExecutor", (Object)taskExecutorRef);
        }
        ArrayList<BeanDefinition> flows = new ArrayList<BeanDefinition>();
        int i = 0;
        for (Element nextElement : flowElements) {
            FlowParser flowParser = new FlowParser(idAttribute + "#" + i, this.jobRepositoryRef);
            flows.add(flowParser.parse(nextElement, parserContext));
            ++i;
        }
        ManagedList managedList = new ManagedList();
        boolean dummy = managedList.addAll(flows);
        stateBuilder.addConstructorArgValue((Object)managedList);
        stateBuilder.addConstructorArgValue((Object)idAttribute);
        return FlowParser.getNextElements(parserContext, (BeanDefinition)stateBuilder.getBeanDefinition(), element);
    }
}

