/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskletElementParser {
    protected AbstractBeanDefinition parseTaskletElement(Element element, ParserContext parserContext) {
        String transactionAttribute;
        String commitInterval;
        String taskExecutorBeanId;
        String writerBeanId;
        String processorBeanId;
        boolean isFaultTolerant = false;
        String skipLimit = element.getAttribute("skip-limit");
        if (!isFaultTolerant) {
            isFaultTolerant = this.checkIntValueForFaultToleranceNeeded(skipLimit);
        }
        String retryLimit = element.getAttribute("retry-limit");
        if (!isFaultTolerant) {
            isFaultTolerant = this.checkIntValueForFaultToleranceNeeded(retryLimit);
        }
        String cacheCapacity = element.getAttribute("cache-capacity");
        if (!isFaultTolerant) {
            isFaultTolerant = this.checkIntValueForFaultToleranceNeeded(cacheCapacity);
        }
        String isReaderTransactionalQueue = element.getAttribute("is-reader-transactional-queue");
        if (!isFaultTolerant && StringUtils.hasText((String)isReaderTransactionalQueue) && "true".equals(isReaderTransactionalQueue)) {
            isFaultTolerant = true;
        }
        this.checkExceptionElementForFaultToleranceNeeded(element, "skippable-exception-classes");
        this.checkExceptionElementForFaultToleranceNeeded(element, "retryable-exception-classes");
        this.checkExceptionElementForFaultToleranceNeeded(element, "fatal-exception-classes");
        RootBeanDefinition bd = isFaultTolerant ? new RootBeanDefinition("org.springframework.batch.core.step.item.FaultTolerantStepFactoryBean", null, null) : new RootBeanDefinition("org.springframework.batch.core.step.item.SimpleStepFactoryBean", null, null);
        String readerBeanId = element.getAttribute("reader");
        if (StringUtils.hasText((String)readerBeanId)) {
            RuntimeBeanReference readerRef = new RuntimeBeanReference(readerBeanId);
            bd.getPropertyValues().addPropertyValue("itemReader", (Object)readerRef);
        }
        if (StringUtils.hasText((String)(processorBeanId = element.getAttribute("processor")))) {
            RuntimeBeanReference processorRef = new RuntimeBeanReference(processorBeanId);
            bd.getPropertyValues().addPropertyValue("itemProcessor", (Object)processorRef);
        }
        if (StringUtils.hasText((String)(writerBeanId = element.getAttribute("writer")))) {
            RuntimeBeanReference writerRef = new RuntimeBeanReference(writerBeanId);
            bd.getPropertyValues().addPropertyValue("itemWriter", (Object)writerRef);
        }
        if (StringUtils.hasText((String)(taskExecutorBeanId = element.getAttribute("task-executor")))) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            bd.getPropertyValues().addPropertyValue("taskExecutor", (Object)taskExecutorRef);
        }
        if (StringUtils.hasText((String)(commitInterval = element.getAttribute("commit-interval")))) {
            bd.getPropertyValues().addPropertyValue("commitInterval", (Object)commitInterval);
        }
        if (StringUtils.hasText((String)skipLimit)) {
            bd.getPropertyValues().addPropertyValue("skipLimit", (Object)skipLimit);
        }
        if (StringUtils.hasText((String)retryLimit)) {
            bd.getPropertyValues().addPropertyValue("retryLimit", (Object)retryLimit);
        }
        if (StringUtils.hasText((String)cacheCapacity)) {
            bd.getPropertyValues().addPropertyValue("cacheCapacity", (Object)cacheCapacity);
        }
        if (StringUtils.hasText((String)(transactionAttribute = element.getAttribute("transaction-attribute")))) {
            bd.getPropertyValues().addPropertyValue("transactionAttribute", (Object)transactionAttribute);
        }
        if (StringUtils.hasText((String)isReaderTransactionalQueue) && isFaultTolerant) {
            bd.getPropertyValues().addPropertyValue("isReaderTransactionalQueue", (Object)isReaderTransactionalQueue);
        }
        this.handleExceptionElement(element, parserContext, (BeanDefinition)bd, "skippable-exception-classes", "skippableExceptionClasses", isFaultTolerant);
        this.handleExceptionElement(element, parserContext, (BeanDefinition)bd, "retryable-exception-classes", "retryableExceptionClasses", isFaultTolerant);
        this.handleExceptionElement(element, parserContext, (BeanDefinition)bd, "fatal-exception-classes", "fatalExceptionClasses", isFaultTolerant);
        this.handleRetryListenersElement(element, (BeanDefinition)bd, parserContext);
        this.handleStreamsElement(element, (BeanDefinition)bd, parserContext);
        return bd;
    }

    private boolean checkIntValueForFaultToleranceNeeded(String stringValue) {
        int value;
        return StringUtils.hasText((String)stringValue) && (value = Integer.valueOf(stringValue).intValue()) > 0;
    }

    private boolean checkExceptionElementForFaultToleranceNeeded(Element element, String subElementName) {
        String exceptions = DomUtils.getChildElementValueByTagName((Element)element, (String)subElementName);
        return StringUtils.hasLength((String)exceptions);
    }

    private void handleExceptionElement(Element element, ParserContext parserContext, BeanDefinition bd, String subElementName, String propertyName, boolean isFaultTolerant) {
        String exceptions = DomUtils.getChildElementValueByTagName((Element)element, (String)subElementName);
        if (StringUtils.hasLength((String)exceptions)) {
            if (isFaultTolerant) {
                String[] exceptionArray = StringUtils.tokenizeToStringArray((String)StringUtils.delete((String)exceptions, (String)","), (String)"\n");
                if (exceptionArray.length > 0) {
                    bd.getPropertyValues().addPropertyValue(propertyName, (Object)exceptionArray);
                }
            } else {
                parserContext.getReaderContext().error(subElementName + " can only be specified for fault-tolerant " + "configurations providing skip-limit, retry-limit or cache-capacity", (Object)element);
            }
        }
    }

    private void handleRetryListenersElement(Element element, BeanDefinition bd, ParserContext parserContext) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"retry-listeners");
        if (listenersElement != null) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ArrayList<Object> retryListenerBeans = new ArrayList<Object>();
            this.handleRetryListenerElements(parserContext, listenersElement, retryListenerBeans);
            ManagedList arguments = new ManagedList();
            arguments.addAll(retryListenerBeans);
            bd.getPropertyValues().addPropertyValue("retryListeners", (Object)arguments);
            parserContext.popAndRegisterContainingComponent();
        }
    }

    private void handleRetryListenerElements(ParserContext parserContext, Element element, List<Object> beans) {
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (listenerElements != null) {
            for (Element listenerElement : listenerElements) {
                String id = listenerElement.getAttribute("id");
                String listenerRef = listenerElement.getAttribute("ref");
                String className = listenerElement.getAttribute("class");
                this.checkListenerElementAttributes(parserContext, element, listenerElement, id, listenerRef, className);
                if (StringUtils.hasText((String)listenerRef)) {
                    RuntimeBeanReference bean = new RuntimeBeanReference(listenerRef);
                    beans.add(bean);
                    continue;
                }
                if (StringUtils.hasText((String)className)) {
                    RootBeanDefinition beanDef = new RootBeanDefinition(className, null, null);
                    if (!StringUtils.hasText((String)id)) {
                        id = parserContext.getReaderContext().generateBeanName((BeanDefinition)beanDef);
                    }
                    beans.add(beanDef);
                    continue;
                }
                parserContext.getReaderContext().error("Neither 'ref' or 'class' specified for <" + listenerElement.getTagName() + "> element", (Object)element);
            }
        }
    }

    private void checkListenerElementAttributes(ParserContext parserContext, Element element, Element listenerElement, String id, String listenerRef, String className) {
        if ((StringUtils.hasText((String)id) || StringUtils.hasText((String)className)) && StringUtils.hasText((String)listenerRef)) {
            NamedNodeMap attributeNodes = listenerElement.getAttributes();
            StringBuilder attributes = new StringBuilder();
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                if (i > 0) {
                    attributes.append(" ");
                }
                attributes.append(attributeNodes.item(i));
            }
            parserContext.getReaderContext().error("Both 'ref' and " + (StringUtils.hasText((String)id) ? "'id'" : "'class'") + " specified; use 'class' with an optional 'id' or just 'ref' for <" + listenerElement.getTagName() + "> element specified with attributes: " + attributes, (Object)element);
        }
    }

    private void handleStreamsElement(Element element, BeanDefinition bd, ParserContext parserContext) {
        Element streamsElement = DomUtils.getChildElementByTagName((Element)element, (String)"streams");
        if (streamsElement != null) {
            ArrayList<RuntimeBeanReference> streamBeans = new ArrayList<RuntimeBeanReference>();
            List streamElements = DomUtils.getChildElementsByTagName((Element)streamsElement, (String)"stream");
            if (streamElements != null) {
                for (Element streamElement : streamElements) {
                    String streamRef = streamElement.getAttribute("ref");
                    if (StringUtils.hasText((String)streamRef)) {
                        RuntimeBeanReference bean = new RuntimeBeanReference(streamRef);
                        streamBeans.add(bean);
                        continue;
                    }
                    parserContext.getReaderContext().error("ref not specified for <" + streamElement.getTagName() + "> element", (Object)element);
                }
            }
            ManagedList arguments = new ManagedList();
            arguments.addAll(streamBeans);
            bd.getPropertyValues().addPropertyValue("streams", (Object)arguments);
        }
    }
}

