/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.repository.JobRestartException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJob
extends AbstractJob {
    private List<Step> steps = new ArrayList<Step>();

    public SimpleJob() {
        this(null);
    }

    public SimpleJob(String name) {
        super(name);
    }

    public void setSteps(List<Step> steps) {
        this.steps.clear();
        this.steps.addAll(steps);
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    @Override
    public Step getStep(String stepName) {
        for (Step step : this.steps) {
            if (!step.getName().equals(stepName)) continue;
            return step;
        }
        return null;
    }

    @Override
    protected void doExecute(JobExecution execution) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        Step step;
        StepExecution stepExecution = null;
        Iterator<Step> i$ = this.steps.iterator();
        while (i$.hasNext() && (stepExecution = this.handleStep(step = i$.next(), execution)).getStatus() == BatchStatus.COMPLETED) {
        }
        if (stepExecution != null) {
            logger.debug((Object)("Upgrading JobExecution status: " + stepExecution));
            execution.upgradeStatus(stepExecution.getStatus());
            execution.setExitStatus(stepExecution.getExitStatus());
        }
    }
}

