/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFlow
implements Flow,
InitializingBean {
    private State startState;
    private Map<String, SortedSet<StateTransition>> transitionMap = new HashMap<String, SortedSet<StateTransition>>();
    private Map<String, State> stateMap = new HashMap<String, State>();
    private List<StateTransition> stateTransitions = new ArrayList<StateTransition>();
    private final String name;

    public SimpleFlow(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setStateTransitions(List<StateTransition> stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    @Override
    public State getState(String stateName) {
        return this.stateMap.get(stateName);
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeTransitions();
    }

    @Override
    public FlowExecution start(FlowExecutor executor) throws FlowExecutionException {
        if (this.startState == null) {
            this.initializeTransitions();
        }
        State state = this.startState;
        String stateName = state.getName();
        return this.resume(stateName, executor);
    }

    @Override
    public FlowExecution resume(String stateName, FlowExecutor executor) throws FlowExecutionException {
        FlowExecutionStatus status = FlowExecutionStatus.UNKNOWN;
        State state = this.stateMap.get(stateName);
        while (state != null && status != FlowExecutionStatus.STOPPED) {
            stateName = state.getName();
            try {
                status = state.handle(executor);
            }
            catch (Exception e) {
                executor.close(new FlowExecution(stateName, status));
                throw new FlowExecutionException(String.format("Ended flow=%s at state=%s with exception", this.name, stateName), e);
            }
            state = this.nextState(stateName, status);
        }
        FlowExecution result = new FlowExecution(stateName, status);
        executor.close(result);
        return result;
    }

    private State nextState(String stateName, FlowExecutionStatus status) throws FlowExecutionException {
        Set set = this.transitionMap.get(stateName);
        if (set == null) {
            throw new FlowExecutionException(String.format("No transitions found in flow=%s for state=%s", this.getName(), stateName));
        }
        String next = null;
        String exitCode = status.getName();
        for (StateTransition stateTransition : set) {
            if (!stateTransition.matches(exitCode)) continue;
            if (stateTransition.isEnd()) {
                return null;
            }
            next = stateTransition.getNext();
            break;
        }
        if (next == null) {
            throw new FlowExecutionException(String.format("Next state not found in flow=%s for state=%s with exit status=%s", this.getName(), stateName, status.getName()));
        }
        if (!this.stateMap.containsKey(next)) {
            throw new FlowExecutionException(String.format("Next state not specified in flow=%s for next=%s", this.getName(), next));
        }
        return this.stateMap.get(next);
    }

    private void initializeTransitions() {
        State state;
        this.startState = null;
        this.transitionMap.clear();
        this.stateMap.clear();
        boolean hasEndStep = false;
        if (this.stateTransitions.isEmpty()) {
            throw new IllegalArgumentException("No start state was found. You must specify at least one step in a job.");
        }
        for (StateTransition stateTransition : this.stateTransitions) {
            state = stateTransition.getState();
            this.stateMap.put(state.getName(), state);
        }
        for (StateTransition stateTransition : this.stateTransitions) {
            String name;
            SortedSet<StateTransition> set;
            state = stateTransition.getState();
            if (!stateTransition.isEnd()) {
                String next = stateTransition.getNext();
                if (!this.stateMap.containsKey(next)) {
                    throw new IllegalArgumentException("Missing state for [" + stateTransition + "]");
                }
            } else {
                hasEndStep = true;
            }
            if ((set = this.transitionMap.get(name = state.getName())) == null) {
                set = new TreeSet<StateTransition>();
                this.transitionMap.put(name, set);
            }
            set.add(stateTransition);
        }
        if (!hasEndStep) {
            throw new IllegalArgumentException("No end state was found.  You must specify at least one transition with no next state.");
        }
        this.startState = this.stateTransitions.get(0).getState();
    }
}

