/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support.state;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.support.state.AbstractState;

public class EndState
extends AbstractState {
    private final FlowExecutionStatus status;
    private final boolean abandon;

    public EndState(FlowExecutionStatus status, String name) {
        this(status, name, false);
    }

    public EndState(FlowExecutionStatus status, String name, boolean abandon) {
        super(name);
        this.status = status;
        this.abandon = abandon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
        JobExecution jobExecution;
        JobExecution jobExecution2 = jobExecution = executor.getJobExecution();
        synchronized (jobExecution2) {
            if (this.status.isStop()) {
                if (!jobExecution.getStepExecutions().isEmpty()) {
                    if (this.abandon) {
                        executor.abandonStepExecution();
                    }
                } else {
                    return FlowExecutionStatus.COMPLETED;
                }
            }
            return this.status;
        }
    }

    public boolean isEndState() {
        return !this.status.isStop();
    }

    public String toString() {
        return super.toString() + " status=[" + this.status + "]";
    }
}

