/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Collections;
import java.util.List;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.PatternMatcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextPromotionListener
extends StepExecutionListenerSupport
implements InitializingBean {
    private List<String> keys = null;
    private List<String> statuses = Collections.singletonList(ExitStatus.COMPLETED.getExitCode());

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        if (this.statuses == null) {
            this.performPromotion(stepExecution);
        } else {
            String exitCode = stepExecution.getExitStatus().getExitCode();
            for (String statusPattern : this.statuses) {
                if (!PatternMatcher.match((String)statusPattern, (String)exitCode)) continue;
                this.performPromotion(stepExecution);
            }
        }
        return null;
    }

    private void performPromotion(StepExecution stepExecution) {
        ExecutionContext stepContext = stepExecution.getExecutionContext();
        ExecutionContext jobContext = stepExecution.getJobExecution().getExecutionContext();
        for (String key : this.keys) {
            jobContext.put(key, stepContext.get(key));
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.keys, (String)"The 'keys' property must be provided");
        Assert.notEmpty(this.statuses, (String)"The 'keys' property must not be empty");
        Assert.notNull(this.statuses, (String)"The 'statuses' property must be provided");
        Assert.notEmpty(this.statuses, (String)"The 'statuses' property must not be empty");
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public void setStatuses(List<String> statuses) {
        this.statuses = statuses;
    }
}

