/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.configuration.util.MethodInvoker;
import org.springframework.batch.core.configuration.util.MethodInvokerUtils;
import org.springframework.batch.core.listener.JobListenerMetaData;
import org.springframework.batch.core.listener.MethodInvokerMethodInterceptor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobListenerFactoryBean
implements FactoryBean,
InitializingBean {
    private Object delegate;
    private Map<String, String> metaDataMap;

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void setMetaDataMap(Map<String, String> metaDataMap) {
        this.metaDataMap = metaDataMap;
    }

    public Object getObject() throws Exception {
        HashMap<String, Set<MethodInvoker>> invokerMap = new HashMap<String, Set<MethodInvoker>>();
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, String>();
        }
        for (JobListenerMetaData metaData : JobListenerMetaData.values()) {
            if (this.metaDataMap.containsKey(metaData.getPropertyName())) continue;
            this.metaDataMap.put(metaData.getPropertyName(), null);
        }
        for (Map.Entry<String, String> entry : this.metaDataMap.entrySet()) {
            JobListenerMetaData metaData = JobListenerMetaData.fromPropertyName(entry.getKey());
            NullIgnoringSet<MethodInvoker> invokers = new NullIgnoringSet<MethodInvoker>();
            invokers.add(this.getMethodInvokerByName(entry.getValue(), this.delegate, JobExecution.class));
            invokers.add(MethodInvokerUtils.getMethodInvokerForInterface(JobExecutionListener.class, metaData.getMethodName(), this.delegate, JobExecution.class));
            invokers.add(MethodInvokerUtils.getMethodInvokerByAnnotation(metaData.getAnnotation(), this.delegate));
            if (invokers.isEmpty()) continue;
            invokerMap.put(metaData.getMethodName(), invokers);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setInterfaces(new Class[]{JobExecutionListener.class});
        proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInvokerMethodInterceptor(invokerMap)));
        return proxyFactory.getProxy();
    }

    private MethodInvoker getMethodInvokerByName(String methodName, Object candidate, Class<?> ... params) {
        if (methodName != null) {
            return MethodInvokerUtils.createMethodInvokerByName(candidate, methodName, false, params);
        }
        return null;
    }

    public Class getObjectType() {
        return JobExecutionListener.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"Delegate listener must not be null");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullIgnoringSet<E>
    extends HashSet<E> {
        private NullIgnoringSet() {
        }

        @Override
        public boolean add(E e) {
            if (e == null) {
                return false;
            }
            return super.add(e);
        }
    }
}

