/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.annotation.AfterJob;
import org.springframework.batch.core.annotation.BeforeJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JobListenerMetaData {
    BEFORE_JOB("beforeJob", "before-job-method", BeforeJob.class),
    AFTER_JOB("afterJob", "after-job-method", AfterJob.class);

    private final String methodName;
    private final String propertyName;
    private final Class<? extends Annotation> annotation;
    private static final Map<String, JobListenerMetaData> propertyMap;

    private JobListenerMetaData(String methodName, String propertyName, Class<? extends Annotation> annotation) {
        this.methodName = methodName;
        this.propertyName = propertyName;
        this.annotation = annotation;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public static JobListenerMetaData fromPropertyName(String propertyName) {
        return propertyMap.get(propertyName);
    }

    static {
        propertyMap = new HashMap<String, JobListenerMetaData>();
        for (JobListenerMetaData metaData : JobListenerMetaData.values()) {
            propertyMap.put(metaData.getPropertyName(), metaData);
        }
    }
}

