/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.configuration.util.MethodInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokerMethodInterceptor
implements MethodInterceptor {
    private final Map<String, Set<MethodInvoker>> invokerMap;

    public MethodInvokerMethodInterceptor(Map<String, Set<MethodInvoker>> invokerMap) {
        this.invokerMap = invokerMap;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Set<MethodInvoker> invokers = this.invokerMap.get(methodName);
        if (invokers == null) {
            return null;
        }
        ExitStatus status = null;
        for (MethodInvoker invoker : invokers) {
            Object retVal = invoker.invokeMethod(invocation.getArguments());
            if (!(retVal instanceof ExitStatus)) continue;
            if (status != null) {
                status = status.and((ExitStatus)retVal);
                continue;
            }
            status = (ExitStatus)retVal;
        }
        return status;
    }
}

