/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.annotation.AfterChunk;
import org.springframework.batch.core.annotation.AfterProcess;
import org.springframework.batch.core.annotation.AfterRead;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeChunk;
import org.springframework.batch.core.annotation.BeforeProcess;
import org.springframework.batch.core.annotation.BeforeRead;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.BeforeWrite;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.annotation.OnReadError;
import org.springframework.batch.core.annotation.OnSkipInProcess;
import org.springframework.batch.core.annotation.OnSkipInRead;
import org.springframework.batch.core.annotation.OnSkipInWrite;
import org.springframework.batch.core.annotation.OnWriteError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StepListenerMetaData {
    BEFORE_STEP("beforeStep", "before-step-method", BeforeStep.class, StepExecutionListener.class, StepExecution.class),
    AFTER_STEP("afterStep", "after-step-method", AfterStep.class, StepExecutionListener.class, StepExecution.class),
    BEFORE_CHUNK("beforeChunk", "before-chunk-method", BeforeChunk.class, ChunkListener.class, new Class[0]),
    AFTER_CHUNK("afterChunk", "after-chunk-method", AfterChunk.class, ChunkListener.class, new Class[0]),
    BEFORE_READ("beforeRead", "before-read-method", BeforeRead.class, ItemReadListener.class, new Class[0]),
    AFTER_READ("afterRead", "after-read-method", AfterRead.class, ItemReadListener.class, Object.class),
    ON_READ_ERROR("onReadError", "on-read-error-method", OnReadError.class, ItemReadListener.class, Exception.class),
    BEFORE_PROCESS("beforeProcess", "before-process-method", BeforeProcess.class, ItemProcessListener.class, Object.class),
    AFTER_PROCESS("afterProcess", "after-process-method", AfterProcess.class, ItemProcessListener.class, Object.class),
    ON_PROCESS_ERROR("onProcessError", "on-process-error-method", OnProcessError.class, ItemProcessListener.class, Object.class, Exception.class),
    BEFORE_WRITE("beforeWrite", "before-write-method", BeforeWrite.class, ItemWriteListener.class, Object.class),
    AFTER_WRITE("afterWrite", "after-write-method", AfterWrite.class, ItemWriteListener.class, Object.class),
    ON_WRITE_ERROR("onWriteError", "on-write-error-method", OnWriteError.class, ItemWriteListener.class, Object.class, Exception.class),
    ON_SKIP_IN_READ("onSkipInRead", "on-skip-in-read-method", OnSkipInRead.class, SkipListener.class, Throwable.class),
    ON_SKIP_IN_PROCESS("onSkipInProcess", "on-skip-in-process-method", OnSkipInProcess.class, SkipListener.class, Object.class, Throwable.class),
    ON_SKIP_IN_WRITE("onSkipInWrite", "on-skip-in-write-method", OnSkipInWrite.class, SkipListener.class, Object.class, Throwable.class);

    private final String methodName;
    private final String propertyName;
    private final Class<? extends Annotation> annotation;
    private final Class<? extends StepListener> listenerInterface;
    private final Class<?>[] paramTypes;
    private static final Map<String, StepListenerMetaData> propertyMap;

    private StepListenerMetaData(String methodName, String propertyName, Class<? extends Annotation> annotation, Class<? extends StepListener> listenerInterface, Class<?> ... paramTypes) {
        this.methodName = methodName;
        this.propertyName = propertyName;
        this.annotation = annotation;
        this.listenerInterface = listenerInterface;
        this.paramTypes = paramTypes;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    public Class<? extends StepListener> getListenerInterface() {
        return this.listenerInterface;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public static StepListenerMetaData fromPropertyName(String propertyName) {
        return propertyMap.get(propertyName);
    }

    static {
        propertyMap = new HashMap<String, StepListenerMetaData>();
        for (StepListenerMetaData metaData : StepListenerMetaData.values()) {
            propertyMap.put(metaData.getPropertyName(), metaData);
        }
    }
}

