/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.partition.support.SimplePartitioner;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStepExecutionSplitter
implements StepExecutionSplitter {
    private static final String STEP_NAME_SEPARATOR = ":";
    private final String stepName;
    private final Partitioner partitioner;
    private final Step step;
    private final JobRepository jobRepository;

    public SimpleStepExecutionSplitter(JobRepository jobRepository, Step step) {
        this(jobRepository, step, new SimplePartitioner());
    }

    public SimpleStepExecutionSplitter(JobRepository jobRepository, Step step, Partitioner partitioner) {
        this.jobRepository = jobRepository;
        this.step = step;
        this.partitioner = partitioner;
        this.stepName = step.getName();
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public Set<StepExecution> split(StepExecution stepExecution, int gridSize) throws JobExecutionException {
        JobExecution jobExecution = stepExecution.getJobExecution();
        int splitSize = this.getSplitSize(stepExecution, gridSize);
        Map<String, ExecutionContext> contexts = this.partitioner.partition(splitSize);
        HashSet<StepExecution> set = new HashSet<StepExecution>(contexts.size());
        for (Map.Entry<String, ExecutionContext> context : contexts.entrySet()) {
            String stepName = this.stepName + STEP_NAME_SEPARATOR + context.getKey();
            StepExecution currentStepExecution = jobExecution.createStepExecution(stepName);
            boolean startable = this.getStartable(currentStepExecution, context.getValue());
            if (!startable) continue;
            this.jobRepository.add(currentStepExecution);
            set.add(currentStepExecution);
        }
        return set;
    }

    private int getSplitSize(StepExecution stepExecution, int gridSize) {
        ExecutionContext context = stepExecution.getExecutionContext();
        String key = SimpleStepExecutionSplitter.class.getSimpleName() + ".GRID_SIZE";
        int result = (int)context.getLong(key, (long)gridSize);
        context.putLong(key, (long)result);
        if (context.isDirty()) {
            this.jobRepository.updateExecutionContext(stepExecution);
        }
        return result;
    }

    private boolean getStartable(StepExecution stepExecution, ExecutionContext context) throws JobExecutionException {
        boolean isRestart;
        String stepName;
        JobInstance jobInstance = stepExecution.getJobExecution().getJobInstance();
        StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, stepName = stepExecution.getStepName());
        boolean bl = isRestart = lastStepExecution != null && lastStepExecution.getStatus() != BatchStatus.COMPLETED;
        if (isRestart) {
            stepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
        } else {
            stepExecution.setExecutionContext(context);
        }
        return this.shouldStart(this.step, lastStepExecution) || isRestart;
    }

    private boolean shouldStart(Step step, StepExecution lastStepExecution) throws JobExecutionException {
        if (lastStepExecution == null) {
            return true;
        }
        BatchStatus stepStatus = lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobExecutionException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        return stepStatus != BatchStatus.COMPLETED || step.isAllowStartIfComplete();
    }
}

