/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.util;

import org.springframework.aop.target.SimpleBeanTargetSource;
import org.springframework.batch.core.scope.util.ContextFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderTargetSource
extends SimpleBeanTargetSource
implements InitializingBean {
    private static final String PLACEHOLDER_PREFIX = "#{";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private ContextFactory contextFactory;

    public void setContextFactory(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contextFactory, (String)"The ContextFactory must be set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getTarget() throws BeansException {
        Object object;
        DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        final TypeConverter typeConverter = listableBeanFactory.getTypeConverter();
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory((BeanFactory)listableBeanFactory);
        beanFactory.copyConfigurationFrom((ConfigurableBeanFactory)listableBeanFactory);
        beanFactory.setTypeConverter(new TypeConverter(){

            public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
                String key;
                Object result = null;
                if (value instanceof String && (key = (String)value).startsWith(PlaceholderTargetSource.PLACEHOLDER_PREFIX) && key.endsWith(PlaceholderTargetSource.PLACEHOLDER_SUFFIX)) {
                    key = PlaceholderTargetSource.this.extractKey(key);
                    result = PlaceholderTargetSource.this.convertFromContext(key, requiredType);
                }
                return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
            }

            public Object convertIfNecessary(Object value, Class requiredType) throws TypeMismatchException {
                return this.convertIfNecessary(value, requiredType, null);
            }
        });
        String beanName = this.getTargetBeanName() + "#" + this.contextFactory.getContextId();
        try {
            String targetBeanName = this.getTargetBeanName();
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition(listableBeanFactory.getMergedBeanDefinition(targetBeanName));
            this.logger.debug((Object)("Rehydrating scoped target: [" + targetBeanName + "]"));
            BeanDefinitionVisitor visitor = new BeanDefinitionVisitor(new StringValueResolver(){

                public String resolveStringValue(String strVal) {
                    if (!strVal.contains(PlaceholderTargetSource.PLACEHOLDER_PREFIX)) {
                        return strVal;
                    }
                    return PlaceholderTargetSource.this.replacePlaceholders(strVal, typeConverter);
                }
            }){

                protected Object resolveValue(Object value) {
                    if (value instanceof TypedStringValue) {
                        TypedStringValue typedStringValue = (TypedStringValue)value;
                        String stringValue = typedStringValue.getValue();
                        if (stringValue != null) {
                            String visitedString = this.resolveStringValue(stringValue);
                            value = new TypedStringValue(visitedString);
                        }
                    } else {
                        value = super.resolveValue(value);
                    }
                    return value;
                }
            };
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            visitor.visitBeanDefinition((BeanDefinition)beanDefinition);
            object = beanFactory.getBean(beanName);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            beanFactory.removeBeanDefinition(beanName);
            beanFactory = null;
            throw throwable;
        }
        beanFactory.removeBeanDefinition(beanName);
        beanFactory = null;
        return object;
    }

    private Object convertFromContext(String key, Class<?> requiredType) {
        Object property;
        Object result = null;
        BeanWrapperImpl wrapper = new BeanWrapperImpl(this.contextFactory.getContext());
        if (wrapper.isReadableProperty(key) && ((property = wrapper.getPropertyValue(key)) == null || requiredType.isAssignableFrom(property.getClass()))) {
            result = property;
        }
        return result;
    }

    private String extractKey(String value) {
        if (value.startsWith(PLACEHOLDER_PREFIX)) {
            value = value.substring(PLACEHOLDER_PREFIX.length());
            value = value.substring(0, value.length() - PLACEHOLDER_SUFFIX.length());
        }
        return value;
    }

    private String replacePlaceholders(String value, TypeConverter typeConverter) {
        StringBuilder result = new StringBuilder(value);
        int first = result.indexOf(PLACEHOLDER_PREFIX);
        int next = result.indexOf(PLACEHOLDER_SUFFIX, first + 1);
        while (first >= 0) {
            Assert.state((next > 0 ? 1 : 0) != 0, (String)String.format("Placeholder key incorrectly specified: use %skey%s (in %s)", PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, value));
            String key = result.substring(first + PLACEHOLDER_PREFIX.length(), next);
            this.replaceIfTypeMatches(result, first, next, key, String.class, typeConverter);
            this.replaceIfTypeMatches(result, first, next, key, Long.class, typeConverter);
            this.replaceIfTypeMatches(result, first, next, key, Integer.class, typeConverter);
            first = result.indexOf(PLACEHOLDER_PREFIX, first + 1);
            next = result.indexOf(PLACEHOLDER_SUFFIX, first + 1);
        }
        this.logger.debug((Object)String.format("Replaced [%s] with [%s]", value, result));
        return result.toString();
    }

    private void replaceIfTypeMatches(StringBuilder result, int first, int next, String key, Class<?> requiredType, TypeConverter typeConverter) {
        Object property = this.convertFromContext(key, requiredType);
        if (property != null) {
            result.replace(first, next + 1, (String)typeConverter.convertIfNecessary(property, String.class));
        }
    }
}

