/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.listener.RepeatListenerSupport;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BatchListenerFactoryHelper {
    BatchListenerFactoryHelper() {
    }

    public static RepeatOperations addChunkListeners(RepeatOperations chunkOperations, StepListener[] listeners) {
        final CompositeChunkListener multicaster = new CompositeChunkListener();
        boolean hasChunkListener = false;
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (!(listener instanceof ChunkListener)) continue;
            hasChunkListener = true;
            multicaster.register((ChunkListener)listener);
        }
        if (hasChunkListener) {
            Assert.state((boolean)(chunkOperations instanceof RepeatTemplate), (String)"Chunk operations is injected but not a RepeatTemplate, so chunk listeners cannot also be registered. Either inject a RepeatTemplate, or remove the ChunkListener.");
            RepeatTemplate stepTemplate = (RepeatTemplate)chunkOperations;
            stepTemplate.registerListener((RepeatListener)new RepeatListenerSupport(){

                public void open(RepeatContext context) {
                    multicaster.beforeChunk();
                }

                public void close(RepeatContext context) {
                    multicaster.afterChunk();
                }
            });
        }
        return chunkOperations;
    }

    public static <T> List<T> getListeners(StepListener[] listeners, Class<? super T> cls) {
        ArrayList<StepListener> list = new ArrayList<StepListener>();
        for (int i = 0; i < listeners.length; ++i) {
            StepListener stepListener = listeners[i];
            if (!cls.isAssignableFrom(stepListener.getClass())) continue;
            StepListener listener = stepListener;
            list.add(listener);
        }
        return list;
    }
}

