/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.step.item.SkipWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk<W>
implements Iterable<W> {
    private List<W> items = new ArrayList<W>();
    private List<SkipWrapper<W>> skips = new ArrayList<SkipWrapper<W>>();
    private List<Exception> errors = new ArrayList<Exception>();
    private Object userData;
    private boolean end;

    public Chunk() {
        this(null, null);
    }

    public Chunk(Collection<? extends W> items) {
        this(items, null);
    }

    public Chunk(Collection<? extends W> items, List<SkipWrapper<W>> skips) {
        if (items != null) {
            this.items = new ArrayList<W>(items);
        }
        if (skips != null) {
            this.skips = new ArrayList<SkipWrapper<W>>(skips);
        }
    }

    public void add(W item) {
        this.items.add(item);
    }

    public void clear() {
        this.items.clear();
        this.skips.clear();
        this.userData = null;
    }

    public List<W> getItems() {
        return Collections.unmodifiableList(new ArrayList<W>(this.items));
    }

    public List<SkipWrapper<W>> getSkips() {
        return Collections.unmodifiableList(this.skips);
    }

    public List<Exception> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void skip(Exception e) {
        this.errors.add(e);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ChunkIterator iterator() {
        return new ChunkIterator(this.items);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd() {
        this.end = true;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public String toString() {
        return String.format("[items=%s, skips=%s]", this.items, this.skips);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChunkIterator
    implements Iterator<W> {
        private final Iterator<W> iterator;
        private W next;

        public ChunkIterator(List<W> items) {
            this.iterator = items.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public W next() {
            this.next = this.iterator.next();
            return this.next;
        }

        public void remove(Exception e) {
            this.remove();
            Chunk.this.skips.add(new SkipWrapper(this.next, e));
        }

        @Override
        public void remove() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else {
                    return;
                }
            }
            this.iterator.remove();
        }
    }
}

