/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkOrientedTasklet<I>
implements Tasklet {
    private static final String INPUTS_KEY = "INPUTS";
    private final ChunkProcessor<I> chunkProcessor;
    private final ChunkProvider<I> chunkProvider;
    private boolean buffering = true;

    public ChunkOrientedTasklet(ChunkProvider<I> chunkProvider, ChunkProcessor<I> chunkProcessor) {
        this.chunkProvider = chunkProvider;
        this.chunkProcessor = chunkProcessor;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Chunk<I> inputs = (Chunk<I>)chunkContext.getAttribute(INPUTS_KEY);
        if (inputs == null) {
            inputs = this.chunkProvider.provide(contribution);
            if (this.buffering) {
                chunkContext.setAttribute(INPUTS_KEY, inputs);
            }
        }
        this.chunkProcessor.process(contribution, inputs);
        chunkContext.removeAttribute(INPUTS_KEY);
        chunkContext.setComplete();
        this.chunkProvider.postProcess(contribution, inputs);
        if (inputs.isEnd()) {
            contribution.setExitStatus(ExitStatus.COMPLETED);
        }
        return RepeatStatus.continueIf((!inputs.isEnd() ? 1 : 0) != 0);
    }
}

