/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.support.DefaultRetryState;
import org.springframework.batch.support.Classifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantChunkProcessor<I, O>
extends SimpleChunkProcessor<I, O> {
    private SkipPolicy itemProcessSkipPolicy = new LimitCheckingItemSkipPolicy(0);
    private SkipPolicy itemWriteSkipPolicy = new LimitCheckingItemSkipPolicy(0);
    private final BatchRetryTemplate batchRetryTemplate;
    private Classifier<Throwable, Boolean> rollbackClassifier;
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean buffering;

    public void setProcessSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemProcessSkipPolicy = SkipPolicy2;
    }

    public void setWriteSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemWriteSkipPolicy = SkipPolicy2;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    public FaultTolerantChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, BatchRetryTemplate batchRetryTemplate) {
        super(itemProcessor, itemWriter);
        this.batchRetryTemplate = batchRetryTemplate;
    }

    @Override
    protected Chunk<O> transform(final StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk outputs = new Chunk();
        final Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            RecoveryCallback recoveryCallback;
            final Object item = iterator.next();
            RetryCallback retryCallback = new RetryCallback<O>(){

                public O doWithRetry(RetryContext context) throws Exception {
                    Object output = FaultTolerantChunkProcessor.this.doProcess(item);
                    if (output == null) {
                        iterator.remove();
                    }
                    return output;
                }
            };
            Object output = this.batchRetryTemplate.execute(retryCallback, recoveryCallback = new RecoveryCallback<O>(){

                public O recover(RetryContext context) throws Exception {
                    Exception e = context.getLastThrowable();
                    if (FaultTolerantChunkProcessor.this.itemProcessSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                        contribution.incrementProcessSkipCount();
                        iterator.remove(e);
                        FaultTolerantChunkProcessor.this.logger.debug((Object)"Skipping after failed process", (Throwable)e);
                        return null;
                    }
                    throw new RetryException("Non-skippable exception in recoverer while processing", (Throwable)e);
                }
            }, (RetryState)new DefaultRetryState(item, this.rollbackClassifier));
            if (output == null) continue;
            outputs.add(output);
        }
        return outputs;
    }

    @Override
    protected void write(final StepContribution contribution, final Chunk<I> inputs, final Chunk<O> outputs) throws Exception {
        RetryCallback<Object> retryCallback = new RetryCallback<Object>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                FaultTolerantChunkProcessor.this.doWrite(outputs.getItems());
                contribution.incrementWriteCount(outputs.size());
                return null;
            }
        };
        RecoveryCallback<Object> recoveryCallback = new RecoveryCallback<Object>(){

            public Object recover(RetryContext context) throws Exception {
                Exception le = context.getLastThrowable();
                if (outputs.size() > 1 && !((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)le)).booleanValue()) {
                    throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", (Throwable)le);
                }
                boolean singleton = outputs.size() == 1;
                Chunk.ChunkIterator inputIterator = inputs.iterator();
                Chunk.ChunkIterator outputIterator = outputs.iterator();
                while (outputIterator.hasNext()) {
                    inputIterator.next();
                    Object item = outputIterator.next();
                    if (singleton) {
                        FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, le, contribution);
                        return null;
                    }
                    try {
                        FaultTolerantChunkProcessor.this.doWrite(Collections.singletonList(item));
                        contribution.incrementWriteCount(1);
                    }
                    catch (Exception e) {
                        FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, e, contribution);
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                            throw e;
                        }
                        throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", (Throwable)e);
                    }
                }
                return null;
            }
        };
        RecoveryCallback<Object> batchRecoveryCallback = new RecoveryCallback<Object>(){

            public Object recover(RetryContext context) throws Exception {
                Exception e = context.getLastThrowable();
                if (outputs.size() > 1 && !((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                    throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", (Throwable)e);
                }
                Chunk.ChunkIterator inputIterator = inputs.iterator();
                Chunk.ChunkIterator outputIterator = outputs.iterator();
                while (outputIterator.hasNext()) {
                    inputIterator.next();
                    outputIterator.next();
                    FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, e, contribution);
                    if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) continue;
                    throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", (Throwable)e);
                }
                return null;
            }
        };
        if (!this.buffering) {
            this.batchRetryTemplate.execute(retryCallback, batchRecoveryCallback, BatchRetryTemplate.createState(inputs.getItems(), this.rollbackClassifier));
        } else {
            this.batchRetryTemplate.execute(retryCallback, recoveryCallback, (RetryState)new DefaultRetryState(inputs, this.rollbackClassifier));
        }
    }

    private void checkSkipPolicy(Chunk.ChunkIterator inputIterator, Chunk.ChunkIterator outputIterator, Exception e, StepContribution contribution) {
        if (!this.itemWriteSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
            throw new RetryException("Non-skippable exception in recoverer", (Throwable)e);
        }
        contribution.incrementWriteSkipCount();
        inputIterator.remove();
        outputIterator.remove(e);
        this.logger.debug((Object)"Skipping after failed write", (Throwable)e);
    }
}

