/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.List;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.SkipWrapper;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleChunkProcessor<I, O>
implements ChunkProcessor<I>,
InitializingBean {
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private final MulticasterBatchListener<I, O> listener = new MulticasterBatchListener();

    private SimpleChunkProcessor() {
        this(null, null);
    }

    public SimpleChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter) {
        this.itemProcessor = itemProcessor;
        this.itemWriter = itemWriter;
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.itemWriter, (String)"ItemWriter must be set");
        Assert.notNull(this.itemProcessor, (String)"ItemProcessor must be set");
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected final O doProcess(I item) throws Exception {
        try {
            this.listener.beforeProcess(item);
            Object result = this.itemProcessor.process(item);
            this.listener.afterProcess(item, result);
            return (O)result;
        }
        catch (Exception e) {
            this.listener.onProcessError(item, e);
            throw e;
        }
    }

    protected final void doWrite(List<O> items) throws Exception {
        try {
            this.listener.beforeWrite(items);
            this.itemWriter.write(items);
            this.listener.afterWrite(items);
        }
        catch (Exception e) {
            this.listener.onWriteError(e, items);
            throw e;
        }
    }

    @Override
    public final void process(StepContribution contribution, Chunk<I> inputs) throws Exception {
        if (inputs.isEmpty()) {
            return;
        }
        Chunk<O> outputs = this.transform(contribution, inputs);
        contribution.incrementFilterCount(inputs.size() - outputs.size());
        Chunk skips = (Chunk)inputs.getUserData();
        if (skips == null) {
            skips = new Chunk();
        }
        outputs = new Chunk<O>(outputs.getItems(), skips.getSkips());
        inputs.setUserData(outputs);
        this.write(contribution, inputs, outputs);
        for (SkipWrapper<I> skipWrapper : inputs.getSkips()) {
            I item = skipWrapper.getItem();
            if (item == null) continue;
            Exception e = skipWrapper.getException();
            try {
                this.listener.onSkipInProcess(item, e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
        for (SkipWrapper<Object> skipWrapper : outputs.getSkips()) {
            Exception e = skipWrapper.getException();
            try {
                this.listener.onSkipInWrite(skipWrapper.getItem(), e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
    }

    protected void write(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs) throws Exception {
        this.doWrite(outputs.getItems());
        contribution.incrementWriteCount(outputs.size());
    }

    protected Chunk<O> transform(StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk<O> outputs = new Chunk<O>();
        Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            O output = this.doProcess(item);
            if (output != null) {
                outputs.add(output);
                continue;
            }
            iterator.remove();
        }
        return outputs;
    }
}

