/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStepFactoryBean<T, S>
implements FactoryBean,
BeanNameAware {
    private static final int DEFAULT_COMMIT_INTERVAL = 1;
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete;
    private ItemReader<? extends T> itemReader;
    private ItemWriter<? super S> itemWriter;
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute;
    private JobRepository jobRepository;
    private boolean singleton = true;
    private ItemStream[] streams = new ItemStream[0];
    private StepListener[] listeners = new StepListener[0];
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ItemProcessor<? super T, ? extends S> itemProcessor = new ItemProcessor<T, S>(){

        public S process(T item) throws Exception {
            return item;
        }
    };
    private int commitInterval = 0;
    private TaskExecutor taskExecutor;
    private RepeatOperations stepOperations;
    private RepeatOperations chunkOperations;
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private CompletionPolicy chunkCompletionPolicy;
    private int throttleLimit = 4;
    private boolean isReaderTransactionalQueue = false;

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.isReaderTransactionalQueue = isReaderTransactionalQueue;
    }

    protected boolean isReaderTransactionalQueue() {
        return this.isReaderTransactionalQueue;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setItemReader(ItemReader<? extends T> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemWriter(ItemWriter<? super S> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setItemProcessor(ItemProcessor<? super T, ? extends S> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    protected StepListener[] getListeners() {
        return this.listeners;
    }

    protected ItemReader<? extends T> getItemReader() {
        return this.itemReader;
    }

    protected ItemWriter<? super S> getItemWriter() {
        return this.itemWriter;
    }

    protected ItemProcessor<? super T, ? extends S> getItemProcessor() {
        return this.itemProcessor;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    protected TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute != null ? this.transactionAttribute : new DefaultTransactionAttribute(){

            public boolean rollbackOn(Throwable ex) {
                return true;
            }
        };
    }

    public final Object getObject() throws Exception {
        TaskletStep step = new TaskletStep(this.getName());
        this.applyConfiguration(step);
        step.afterPropertiesSet();
        return step;
    }

    public Class<Step> getObjectType() {
        return Step.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    protected RepeatOperations getStepOperations() {
        return this.stepOperations;
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setChunkOperations(RepeatOperations chunkOperations) {
        this.chunkOperations = chunkOperations;
    }

    protected RepeatOperations getChunkOperations() {
        return this.chunkOperations;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setThrottleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    protected void applyConfiguration(TaskletStep step) {
        RepeatTemplate repeatTemplate;
        Assert.notNull(this.getItemReader(), (String)"ItemReader must be provided");
        Assert.notNull(this.getItemWriter(), (String)"ItemWriter must be provided");
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager must be provided");
        step.setTransactionManager(this.transactionManager);
        if (this.transactionAttribute != null) {
            step.setTransactionAttribute(this.transactionAttribute);
        }
        step.setJobRepository(this.jobRepository);
        step.setStartLimit(this.startLimit);
        step.setAllowStartIfComplete(this.allowStartIfComplete);
        step.setStreams(this.streams);
        if (this.chunkOperations == null) {
            repeatTemplate = new RepeatTemplate();
            repeatTemplate.setCompletionPolicy(this.getChunkCompletionPolicy());
            this.chunkOperations = repeatTemplate;
        }
        if (this.stepOperations == null) {
            this.stepOperations = new RepeatTemplate();
            if (this.taskExecutor != null) {
                repeatTemplate = new TaskExecutorRepeatTemplate();
                repeatTemplate.setTaskExecutor(this.taskExecutor);
                repeatTemplate.setThrottleLimit(this.throttleLimit);
                this.stepOperations = repeatTemplate;
            }
            ((RepeatTemplate)this.stepOperations).setExceptionHandler(this.exceptionHandler);
        }
        step.setStepOperations(this.stepOperations);
        SimpleChunkProvider<T> chunkProvider = this.configureChunkProvider();
        SimpleChunkProcessor<T, S> chunkProcessor = this.configureChunkProcessor();
        this.registerItemListeners(chunkProvider, chunkProcessor);
        this.registerStepListeners(step, this.chunkOperations);
        ChunkOrientedTasklet<T> tasklet = new ChunkOrientedTasklet<T>(chunkProvider, chunkProcessor);
        tasklet.setBuffering(!this.isReaderTransactionalQueue());
        step.setTasklet(tasklet);
    }

    protected SimpleChunkProvider<T> configureChunkProvider() {
        return new SimpleChunkProvider<T>(this.itemReader, this.chunkOperations);
    }

    protected SimpleChunkProcessor<T, S> configureChunkProcessor() {
        return new SimpleChunkProcessor<T, S>(this.itemProcessor, this.itemWriter);
    }

    private CompletionPolicy getChunkCompletionPolicy() {
        Assert.state((this.chunkCompletionPolicy == null || this.commitInterval == 0 ? 1 : 0) != 0, (String)"You must specify either a chunkCompletionPolicy or a commitInterval but not both.");
        Assert.state((this.commitInterval >= 0 ? 1 : 0) != 0, (String)"The commitInterval must be positive or zero (for default value).");
        if (this.chunkCompletionPolicy != null) {
            return this.chunkCompletionPolicy;
        }
        if (this.commitInterval == 0) {
            this.logger.info((Object)"Setting commit interval to default value (1)");
            this.commitInterval = 1;
        }
        return new SimpleCompletionPolicy(this.commitInterval);
    }

    private void registerStepListeners(TaskletStep step, RepeatOperations chunkOperations) {
        ArrayList<StepListener> chunkListeners = new ArrayList<StepListener>(Arrays.asList(this.getListeners()));
        for (Object itemHandler : new Object[]{this.itemReader, this.itemWriter, this.itemProcessor}) {
            if (itemHandler instanceof ItemStream) {
                step.registerStream((ItemStream)itemHandler);
            }
            if (itemHandler instanceof StepExecutionListener) {
                step.registerStepExecutionListener((StepExecutionListener)itemHandler);
            }
            if (!(itemHandler instanceof ChunkListener)) continue;
            chunkListeners.add((StepListener)itemHandler);
        }
        BatchListenerFactoryHelper.addChunkListeners(chunkOperations, chunkListeners.toArray(new StepListener[0]));
        step.setStepExecutionListeners(BatchListenerFactoryHelper.getListeners(this.listeners, StepExecutionListener.class).toArray(new StepExecutionListener[0]));
    }

    private void registerItemListeners(SimpleChunkProvider<T> chunkProvider, SimpleChunkProcessor<T, S> chunkProcessor) {
        chunkProvider.setListeners(BatchListenerFactoryHelper.getListeners(this.getListeners(), ItemReadListener.class));
        chunkProvider.setListeners(BatchListenerFactoryHelper.getListeners(this.getListeners(), SkipListener.class));
        chunkProcessor.setListeners(BatchListenerFactoryHelper.getListeners(this.getListeners(), ItemProcessListener.class));
        chunkProcessor.setListeners(BatchListenerFactoryHelper.getListeners(this.getListeners(), ItemWriteListener.class));
        chunkProcessor.setListeners(BatchListenerFactoryHelper.getListeners(this.getListeners(), SkipListener.class));
        for (Object itemHandler : new Object[]{this.getItemReader(), this.getItemWriter(), this.getItemProcessor()}) {
            if (itemHandler instanceof SkipListener) {
                chunkProvider.registerListener((StepListener)itemHandler);
                chunkProcessor.registerListener((StepListener)itemHandler);
                continue;
            }
            if (itemHandler instanceof ItemReadListener) {
                chunkProvider.registerListener((StepListener)itemHandler);
            }
            if (!(itemHandler instanceof ItemProcessListener) && !(itemHandler instanceof ItemWriteListener)) continue;
            chunkProcessor.registerListener((StepListener)itemHandler);
        }
    }
}

