/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContextRepeatCallback;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.StepInterruptionPolicy;
import org.springframework.batch.core.step.ThreadStepInterruptionPolicy;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class TaskletStep
extends AbstractStep {
    private static final Log logger = LogFactory.getLog(TaskletStep.class);
    private RepeatOperations stepOperations = new RepeatTemplate();
    private StepInterruptionPolicy interruptionPolicy = new ThreadStepInterruptionPolicy();
    private CompositeItemStream stream = new CompositeItemStream();
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(){

        public boolean rollbackOn(Throwable ex) {
            return true;
        }
    };
    private Tasklet tasklet;
    private Semaphore semaphore = new Semaphore(1);

    public TaskletStep() {
        this(null);
    }

    public TaskletStep(String name) {
        super(name);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager is mandatory");
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
        if (tasklet instanceof StepExecutionListener) {
            this.registerStepExecutionListener((StepExecutionListener)((Object)tasklet));
        }
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    public void setStreams(ItemStream[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            this.registerStream(streams[i]);
        }
    }

    public void registerStream(ItemStream stream) {
        this.stream.register(stream);
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setInterruptionPolicy(StepInterruptionPolicy interruptionPolicy) {
        this.interruptionPolicy = interruptionPolicy;
    }

    protected void doExecute(StepExecution stepExecution) throws Exception {
        this.stream.update(stepExecution.getExecutionContext());
        this.getJobRepository().updateExecutionContext(stepExecution);
        this.stepOperations.iterate((RepeatCallback)new StepContextRepeatCallback(stepExecution){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RepeatStatus doInChunkContext(RepeatContext repeatContext, ChunkContext chunkContext) throws Exception {
                StepExecution stepExecution = chunkContext.getStepContext().getStepExecution();
                StepContribution contribution = stepExecution.createStepContribution();
                TaskletStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                RepeatStatus result = RepeatStatus.CONTINUABLE;
                TransactionStatus transaction = TaskletStep.this.transactionManager.getTransaction((TransactionDefinition)TaskletStep.this.transactionAttribute);
                boolean locked = false;
                try {
                    block19: {
                        try {
                            try {
                                result = TaskletStep.this.tasklet.execute(contribution, chunkContext);
                                Object var9_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                logger.debug((Object)("Applying contribution: " + contribution));
                                stepExecution.apply(contribution);
                                throw throwable;
                            }
                            logger.debug((Object)("Applying contribution: " + contribution));
                            stepExecution.apply(contribution);
                            try {
                                TaskletStep.this.semaphore.acquire();
                                locked = true;
                            }
                            catch (InterruptedException e) {
                                stepExecution.setStatus(BatchStatus.STOPPED);
                                Thread.currentThread().interrupt();
                            }
                            TaskletStep.this.stream.update(stepExecution.getExecutionContext());
                            try {
                                TaskletStep.this.getJobRepository().updateExecutionContext(stepExecution);
                                TaskletStep.this.transactionManager.commit(transaction);
                                stepExecution.incrementCommitCount();
                                logger.debug((Object)("Saving step execution after commit: " + stepExecution));
                                TaskletStep.this.getJobRepository().update(stepExecution);
                            }
                            catch (Exception e) {
                                throw new AbstractStep.FatalException("Fatal failure detected", e);
                            }
                            Object var11_19 = null;
                            if (!locked) break block19;
                        }
                        catch (AbstractStep.FatalException e) {
                            try {
                                TaskletStep.this.rollback(stepExecution, transaction);
                            }
                            catch (Exception rollbackException) {
                                logger.error((Object)"Rollback caused by fatal failure failed", (Throwable)rollbackException);
                            }
                            throw e;
                        }
                        catch (Error e) {
                            try {
                                TaskletStep.this.rollback(stepExecution, transaction);
                            }
                            catch (Exception rollbackException) {
                                logger.error((Object)"Fatal rollback failure, original exception that caused the rollback is", (Throwable)e);
                                throw new AbstractStep.FatalException("Failed while processing rollback", rollbackException);
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            try {
                                TaskletStep.this.rollback(stepExecution, transaction);
                            }
                            catch (Exception rollbackException) {
                                logger.error((Object)"Fatal rollback failure, original exception that caused the rollback is", (Throwable)e);
                                throw new AbstractStep.FatalException("Failed while processing rollback", rollbackException);
                            }
                            throw e;
                        }
                        TaskletStep.this.semaphore.release();
                    }
                    locked = false;
                }
                catch (Throwable throwable) {
                    Object var11_20 = null;
                    if (locked) {
                        TaskletStep.this.semaphore.release();
                    }
                    locked = false;
                    throw throwable;
                }
                TaskletStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                return result;
            }
        });
    }

    protected void close(ExecutionContext ctx) throws Exception {
        this.stream.close();
    }

    protected void open(ExecutionContext ctx) throws Exception {
        this.stream.open(ctx);
    }

    private void rollback(StepExecution stepExecution, TransactionStatus transaction) {
        this.transactionManager.rollback(transaction);
        stepExecution.incrementRollbackCount();
    }
}

