/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.batch.core.JobParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobParameters
implements Serializable {
    private final Map<String, JobParameter> parameters;

    public JobParameters() {
        this.parameters = new LinkedHashMap<String, JobParameter>();
    }

    public JobParameters(Map<String, JobParameter> parameters) {
        this.parameters = new LinkedHashMap<String, JobParameter>(parameters);
    }

    public long getLong(String key) {
        return (Long)this.parameters.get(key).getValue();
    }

    public long getLong(String key, long defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getLong(key);
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.parameters.get(key).toString();
    }

    public String getString(String key, String defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getString(key);
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        return (Double)this.parameters.get(key).getValue();
    }

    public double getDouble(String key, double defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDouble(key);
        }
        return defaultValue;
    }

    public Date getDate(String key) {
        return (Date)this.parameters.get(key).getValue();
    }

    public Date getDate(String key, Date defaultValue) {
        if (this.parameters.containsKey(key)) {
            return this.getDate(key);
        }
        return defaultValue;
    }

    public Map<String, JobParameter> getParameters() {
        return new LinkedHashMap<String, JobParameter>(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JobParameters rhs = (JobParameters)obj;
        return ((Object)this.parameters).equals(rhs.parameters);
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 21).append(this.parameters).toHashCode();
    }

    public String toString() {
        return this.parameters.toString();
    }
}

