/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.listener.AbstractListenerFactoryBean;
import org.springframework.batch.core.listener.ListenerMetaData;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerParser {
    private static final String ID_ATTR = "id";
    private static final String REF_ATTR = "ref";
    private static final String CLASS_ATTR = "class";

    public AbstractBeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(this.getBeanClass());
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    public void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String id = element.getAttribute(ID_ATTR);
        String listenerRef = element.getAttribute(REF_ATTR);
        String className = element.getAttribute(CLASS_ATTR);
        this.checkListenerElementAttributes(parserContext, element, id, listenerRef, className);
        if (StringUtils.hasText((String)listenerRef)) {
            builder.addPropertyReference("delegate", listenerRef);
        } else if (StringUtils.hasText((String)className)) {
            RootBeanDefinition beanDef = new RootBeanDefinition(className, null, null);
            builder.addPropertyValue("delegate", (Object)beanDef);
        } else {
            parserContext.getReaderContext().error("Neither 'ref' or 'class' specified for <" + element.getTagName() + "> element", (Object)element);
        }
        ManagedMap metaDataMap = new ManagedMap();
        for (String metaDataPropertyName : this.getMethodNameAttributes()) {
            String listenerMethod = element.getAttribute(metaDataPropertyName);
            if (!StringUtils.hasText((String)listenerMethod)) continue;
            metaDataMap.put((Object)metaDataPropertyName, (Object)listenerMethod);
        }
        builder.addPropertyValue("metaDataMap", (Object)metaDataMap);
    }

    private void checkListenerElementAttributes(ParserContext parserContext, Element element, String id, String listenerRef, String className) {
        if (StringUtils.hasText((String)className) && StringUtils.hasText((String)listenerRef)) {
            NamedNodeMap attributeNodes = element.getAttributes();
            StringBuilder attributes = new StringBuilder();
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                if (i > 0) {
                    attributes.append(" ");
                }
                attributes.append(attributeNodes.item(i));
            }
            parserContext.getReaderContext().error("Either 'ref' or 'class' may be specified, but not both; <" + element.getTagName() + "> element specified with attributes: " + attributes, (Object)element);
        }
    }

    private List<String> getMethodNameAttributes() {
        ArrayList<String> methodNameAttributes = new ArrayList<String>();
        for (ListenerMetaData metaData : this.getMetaDataValues()) {
            methodNameAttributes.add(metaData.getMethodName());
        }
        return methodNameAttributes;
    }

    protected abstract Class<? extends AbstractListenerFactoryBean> getBeanClass();

    protected abstract ListenerMetaData[] getMetaDataValues();
}

