/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.List;
import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.FlowParser;
import org.springframework.batch.core.configuration.xml.JobExecutionListenerParser;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobParser
extends AbstractSingleBeanDefinitionParser {
    private static final JobExecutionListenerParser jobListenerParser = new JobExecutionListenerParser();

    protected Class<FlowJob> getBeanClass(Element element) {
        return FlowJob.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String incrementer;
        String repositoryAttribute;
        String parentRef;
        CoreNamespaceUtils.checkForStepScope(parserContext, parserContext.extractSource((Object)element));
        CoreNamespaceUtils.addRangePropertyEditor(parserContext);
        String jobName = element.getAttribute("id");
        builder.addConstructorArgValue((Object)jobName);
        String isAbstract = element.getAttribute("abstract");
        if (StringUtils.hasText((String)isAbstract)) {
            builder.setAbstract(Boolean.valueOf(isAbstract).booleanValue());
        }
        if (StringUtils.hasText((String)(parentRef = element.getAttribute("parent")))) {
            builder.setParentName(parentRef);
        }
        if (!StringUtils.hasText((String)(repositoryAttribute = element.getAttribute("job-repository")))) {
            repositoryAttribute = "jobRepository";
        }
        builder.addPropertyReference("jobRepository", repositoryAttribute);
        String restartableAttribute = element.getAttribute("restartable");
        if (StringUtils.hasText((String)restartableAttribute)) {
            builder.addPropertyValue("restartable", (Object)restartableAttribute);
        }
        if (StringUtils.hasText((String)(incrementer = element.getAttribute("incrementer")))) {
            builder.addPropertyReference("jobParametersIncrementer", incrementer);
        }
        FlowParser flowParser = new FlowParser(jobName, repositoryAttribute);
        BeanDefinition flowDef = flowParser.parse(element, parserContext);
        builder.addPropertyValue("flow", (Object)flowDef);
        List listenersElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listeners");
        if (listenersElements.size() == 1) {
            Element listenersElement = (Element)listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList listeners = new ManagedList();
            listeners.setMergeEnabled(Boolean.valueOf(listenersElement.getAttribute("merge")).booleanValue());
            List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)"listener");
            for (Element listenerElement : listenerElements) {
                listeners.add((Object)jobListenerParser.parse(listenerElement, parserContext));
            }
            builder.addPropertyValue("jobExecutionListeners", (Object)listeners);
            parserContext.popAndRegisterContainingComponent();
        } else if (listenersElements.size() > 1) {
            parserContext.getReaderContext().error("The '<listeners/>' element may not appear more than once in a single <job/>.", (Object)element);
        }
    }
}

