/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.FaultTolerantStepFactoryBean;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.retry.RetryListener;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StepParserStepFactoryBean<I, O>
implements FactoryBean,
BeanNameAware {
    private String name;
    private Boolean allowStartIfComplete;
    private JobRepository jobRepository;
    private Integer startLimit;
    private Tasklet tasklet;
    private PlatformTransactionManager transactionManager;
    private StepListener[] listeners;
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses;
    private int transactionTimeout = -1;
    private Propagation propagation;
    private Isolation isolation;
    private Integer cacheCapacity;
    private CompletionPolicy chunkCompletionPolicy;
    private Integer commitInterval;
    private Boolean isReaderTransactionalQueue;
    private Integer retryLimit;
    private Integer skipLimit;
    private TaskExecutor taskExecutor;
    private ItemReader<? extends I> itemReader;
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private RetryListener[] retryListeners;
    private Collection<Class<? extends Throwable>> skippableExceptionClasses;
    private Collection<Class<? extends Throwable>> retryableExceptionClasses;
    private Collection<Class<? extends Throwable>> fatalExceptionClasses;
    private ItemStream[] streams;
    private boolean hasChunkElement = false;

    StepParserStepFactoryBean() {
    }

    public final Object getObject() throws Exception {
        if (this.hasChunkElement) {
            Assert.isNull((Object)this.tasklet, (String)("Step [" + this.name + "] has both a <chunk/> element and a 'ref' attribute  referencing a Tasklet."));
            if (this.isFaultTolerant()) {
                FaultTolerantStepFactoryBean fb = new FaultTolerantStepFactoryBean();
                this.configureSimple(fb);
                this.configureFaultTolerant(fb);
                return fb.getObject();
            }
            this.validateSimpleStep();
            SimpleStepFactoryBean fb = new SimpleStepFactoryBean();
            this.configureSimple(fb);
            return fb.getObject();
        }
        if (this.tasklet != null) {
            TaskletStep ts = new TaskletStep();
            this.configureTaskletStep(ts);
            return ts;
        }
        throw new IllegalStateException("Step [" + this.name + "] has neither a <chunk/> element nor a 'ref' attribute referencing a Tasklet.");
    }

    private void configureSimple(SimpleStepFactoryBean<I, O> fb) {
        if (this.name != null) {
            fb.setBeanName(this.name);
        }
        if (this.allowStartIfComplete != null) {
            fb.setAllowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.jobRepository != null) {
            fb.setJobRepository(this.jobRepository);
        }
        if (this.startLimit != null) {
            fb.setStartLimit(this.startLimit);
        }
        if (this.transactionManager != null) {
            fb.setTransactionManager(this.transactionManager);
        }
        if (this.listeners != null) {
            fb.setListeners(this.listeners);
        }
        if (this.transactionTimeout >= 0) {
            fb.setTransactionTimeout(this.transactionTimeout);
        }
        if (this.propagation != null) {
            fb.setPropagation(this.propagation);
        }
        if (this.isolation != null) {
            fb.setIsolation(this.isolation);
        }
        if (this.chunkCompletionPolicy != null) {
            fb.setChunkCompletionPolicy(this.chunkCompletionPolicy);
        }
        if (this.commitInterval != null) {
            fb.setCommitInterval(this.commitInterval);
        }
        if (this.taskExecutor != null) {
            fb.setTaskExecutor(this.taskExecutor);
        }
        if (this.itemReader != null) {
            fb.setItemReader(this.itemReader);
        }
        if (this.itemProcessor != null) {
            fb.setItemProcessor(this.itemProcessor);
        }
        if (this.itemWriter != null) {
            fb.setItemWriter(this.itemWriter);
        }
        if (this.streams != null) {
            fb.setStreams(this.streams);
        }
    }

    private void configureFaultTolerant(FaultTolerantStepFactoryBean<I, O> fb) {
        if (this.cacheCapacity != null) {
            fb.setCacheCapacity(this.cacheCapacity);
        }
        if (this.isReaderTransactionalQueue != null) {
            fb.setIsReaderTransactionalQueue(this.isReaderTransactionalQueue);
        }
        if (this.retryLimit != null) {
            fb.setRetryLimit(this.retryLimit);
        }
        if (this.skipLimit != null) {
            fb.setSkipLimit(this.skipLimit);
        }
        if (this.retryListeners != null) {
            fb.setRetryListeners(this.retryListeners);
        }
        if (this.skippableExceptionClasses != null) {
            fb.setSkippableExceptionClasses(this.skippableExceptionClasses);
        }
        if (this.retryableExceptionClasses != null) {
            fb.setRetryableExceptionClasses(this.retryableExceptionClasses);
        }
        if (this.fatalExceptionClasses != null) {
            fb.setFatalExceptionClasses(this.fatalExceptionClasses);
        }
        if (this.noRollbackExceptionClasses != null) {
            fb.setNoRollbackExceptionClasses(this.noRollbackExceptionClasses);
        }
    }

    private void configureTaskletStep(TaskletStep ts) {
        if (this.name != null) {
            ts.setName(this.name);
        }
        if (this.allowStartIfComplete != null) {
            ts.setAllowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.jobRepository != null) {
            ts.setJobRepository(this.jobRepository);
        }
        if (this.startLimit != null) {
            ts.setStartLimit(this.startLimit);
        }
        if (this.tasklet != null) {
            ts.setTasklet(this.tasklet);
        }
        if (this.transactionManager != null) {
            ts.setTransactionManager(this.transactionManager);
        }
        if (this.listeners != null) {
            int i = 0;
            StepExecutionListener[] newListeners = new StepExecutionListener[this.listeners.length];
            for (StepListener listener : this.listeners) {
                newListeners[i++] = (StepExecutionListener)listener;
            }
            ts.setStepExecutionListeners(newListeners);
        }
        if (this.transactionTimeout >= 0 || this.propagation != null || this.isolation != null) {
            DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
            attribute.setPropagationBehavior(this.propagation.value());
            attribute.setIsolationLevel(this.isolation.value());
            attribute.setTimeout(this.transactionTimeout);
            ts.setTransactionAttribute((TransactionAttribute)new DefaultTransactionAttribute((TransactionAttribute)attribute){

                public boolean rollbackOn(Throwable ex) {
                    return true;
                }
            });
        }
    }

    private void validateSimpleStep() {
        PropertyNamePair[] notPermitted = new PropertyNamePair[]{new PropertyNamePair(this.retryListeners, "retry-listeners"), new PropertyNamePair(this.skippableExceptionClasses, "skippable-exception-classes"), new PropertyNamePair(this.retryableExceptionClasses, "retryable-exception-classes"), new PropertyNamePair(this.fatalExceptionClasses, "fatal-exception-classes")};
        ArrayList<String> wrong = new ArrayList<String>();
        for (PropertyNamePair field : notPermitted) {
            if (field.getProperty() == null) continue;
            wrong.add(field.getName());
        }
        if (!wrong.isEmpty()) {
            throw new IllegalArgumentException("The field" + (wrong.size() > 1 ? "s " : " ") + wrong + (wrong.size() == 1 ? " is" : " are") + " not permitted on the simple step [" + this.name + "].  " + (wrong.size() == 1 ? "It" : "They") + " can only be specified for fault-tolerant " + "configurations providing skip-limit, retry-limit, or cache-capacity");
        }
    }

    private boolean isFaultTolerant() {
        return this.isPositive(this.skipLimit) || this.isPositive(this.retryLimit) || this.isPositive(this.cacheCapacity) || this.isTrue(this.isReaderTransactionalQueue);
    }

    private boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    private boolean isPositive(Integer n) {
        return n != null && n > 0;
    }

    public Class<Step> getObjectType() {
        return Step.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.isReaderTransactionalQueue = isReaderTransactionalQueue;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setItemReader(ItemReader<? extends I> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkippableExceptionClasses(Collection<Class<? extends Throwable>> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setRetryableExceptionClasses(Collection<Class<? extends Throwable>> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setFatalExceptionClasses(Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setHasChunkElement(boolean hasChunkElement) {
        this.hasChunkElement = hasChunkElement;
    }

    private static class PropertyNamePair {
        private Object property;
        private String name;

        public PropertyNamePair(Object property, String name) {
            this.property = property;
            this.name = name;
        }

        public Object getProperty() {
            return this.property;
        }

        public String getName() {
            return this.name;
        }
    }
}

