/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.explore.support;

import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJobExplorer
implements JobExplorer {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;
    private ExecutionContextDao ecDao;

    SimpleJobExplorer() {
    }

    public SimpleJobExplorer(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao ecDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.ecDao = ecDao;
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(jobInstance);
        for (JobExecution jobExecution : executions) {
            this.getJobExecutionDependencies(jobExecution);
        }
        return executions;
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        Set<JobExecution> executions = this.jobExecutionDao.findRunningJobExecutions(jobName);
        for (JobExecution jobExecution : executions) {
            this.getJobExecutionDependencies(jobExecution);
        }
        return executions;
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(executionId);
        if (jobExecution == null) {
            return null;
        }
        this.getJobExecutionDependencies(jobExecution);
        return jobExecution;
    }

    @Override
    public StepExecution getStepExecution(Long jobExecutionId, Long executionId) {
        StepExecution stepExecution = this.stepExecutionDao.getStepExecution(this.getJobExecution(jobExecutionId), executionId);
        this.getStepExecutionDependencies(stepExecution);
        return stepExecution;
    }

    @Override
    public JobInstance getJobInstance(Long instanceId) {
        return this.jobInstanceDao.getJobInstance(instanceId);
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        return this.jobInstanceDao.getJobInstances(jobName, start, count);
    }

    private void getJobExecutionDependencies(JobExecution jobExecution) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobExecution);
        this.stepExecutionDao.addStepExecutions(jobExecution);
        jobExecution.setJobInstance(jobInstance);
        jobExecution.setExecutionContext(this.ecDao.getExecutionContext(jobExecution));
    }

    private void getStepExecutionDependencies(StepExecution stepExecution) {
        stepExecution.setExecutionContext(this.ecDao.getExecutionContext(stepExecution));
    }
}

