/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.batch.core.listener.ListenerMetaData;
import org.springframework.batch.core.listener.MethodInvokerMethodInterceptor;
import org.springframework.batch.support.MethodInvoker;
import org.springframework.batch.support.MethodInvokerUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerFactoryBean
implements FactoryBean,
InitializingBean {
    private Object delegate;
    private Map<String, String> metaDataMap;

    public Object getObject() {
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, String>();
        }
        for (ListenerMetaData metaData : this.getMetaDataValues()) {
            if (this.metaDataMap.containsKey(metaData.getPropertyName())) continue;
            this.metaDataMap.put(metaData.getPropertyName(), null);
        }
        HashSet listenerInterfaces = new HashSet();
        HashMap<String, Set<MethodInvoker>> invokerMap = new HashMap<String, Set<MethodInvoker>>();
        for (Map.Entry<String, String> entry : this.metaDataMap.entrySet()) {
            ListenerMetaData metaData = this.getMetaDataFromPropertyName(entry.getKey());
            NullIgnoringSet<MethodInvoker> invokers = new NullIgnoringSet<MethodInvoker>();
            invokers.add(this.getMethodInvokerByName(entry.getValue(), this.delegate, metaData.getParamTypes()));
            invokers.add(MethodInvokerUtils.getMethodInvokerForInterface(metaData.getListenerInterface(), (String)metaData.getMethodName(), (Object)this.delegate, (Class[])metaData.getParamTypes()));
            invokers.add(MethodInvokerUtils.getMethodInvokerByAnnotation(metaData.getAnnotation(), (Object)this.delegate, (Class[])metaData.getParamTypes()));
            if (invokers.isEmpty()) continue;
            invokerMap.put(metaData.getMethodName(), invokers);
            listenerInterfaces.add(metaData.getListenerInterface());
        }
        if (listenerInterfaces.isEmpty()) {
            listenerInterfaces.add(this.getDefaultListenerClass());
        }
        boolean ordered = false;
        if (this.delegate instanceof Ordered) {
            ordered = true;
            listenerInterfaces.add(Ordered.class);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.delegate instanceof Advised) {
            proxyFactory.setTargetSource(((Advised)this.delegate).getTargetSource());
        } else {
            proxyFactory.setTarget(this.delegate);
        }
        proxyFactory.setInterfaces(listenerInterfaces.toArray(new Class[0]));
        proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInvokerMethodInterceptor(invokerMap, ordered)));
        return proxyFactory.getProxy();
    }

    protected abstract ListenerMetaData getMetaDataFromPropertyName(String var1);

    protected abstract ListenerMetaData[] getMetaDataValues();

    protected abstract Class<?> getDefaultListenerClass();

    protected MethodInvoker getMethodInvokerByName(String methodName, Object candidate, Class<?> ... params) {
        if (methodName != null) {
            return MethodInvokerUtils.getMethodInvokerByName((Object)candidate, (String)methodName, (boolean)false, (Class[])params);
        }
        return null;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void setMetaDataMap(Map<String, String> metaDataMap) {
        this.metaDataMap = metaDataMap;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"Delegate must not be null");
    }

    public static boolean isListener(Object target, Class<?> listenerType, ListenerMetaData[] metaDataValues) {
        if (listenerType.isInstance(target)) {
            return true;
        }
        if (target instanceof Advised && listenerType.isAssignableFrom(((Advised)target).getTargetSource().getTargetClass())) {
            return true;
        }
        for (ListenerMetaData metaData : metaDataValues) {
            if (MethodInvokerUtils.getMethodInvokerByAnnotation(metaData.getAnnotation(), (Object)target) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NullIgnoringSet<E>
    extends HashSet<E> {
        protected NullIgnoringSet() {
        }

        @Override
        public boolean add(E e) {
            if (e == null) {
                return false;
            }
            return super.add(e);
        }
    }
}

