/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProcessor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProvider;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.item.SimpleRetryExceptionHandler;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.policy.ExceptionClassifierRetryPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.NeverRetryPolicy;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantStepFactoryBean<T, S>
extends SimpleStepFactoryBean<T, S> {
    private Collection<Class<? extends Throwable>> skippableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Collection<Class<? extends Throwable>> fatalExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Collection<Class<? extends Throwable>> retryableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private int cacheCapacity = 0;
    private int retryLimit = 0;
    private int skipLimit = 0;
    private BackOffPolicy backOffPolicy;
    private RetryListener[] retryListeners;
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private KeyGenerator keyGenerator;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setRetryableExceptionClasses(Collection<Class<? extends Throwable>> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkippableExceptionClasses(Collection<Class<? extends Throwable>> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setFatalExceptionClasses(Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }

    protected Classifier<Throwable, Boolean> getRollbackClassifier() {
        return new BinaryExceptionClassifier(this.noRollbackExceptionClasses, false);
    }

    @Override
    protected void applyConfiguration(TaskletStep step) {
        this.addFatalExceptionIfMissing(SkipLimitExceededException.class, NonSkippableReadException.class, SkipListenerFailedException.class, RetryException.class, JobInterruptedException.class);
        super.applyConfiguration(step);
    }

    @Override
    protected void registerStreams(TaskletStep step, ItemStream[] streams) {
        CompositeItemStream composite = new CompositeItemStream();
        boolean streamIsReader = false;
        for (ItemStream stream : streams) {
            if (stream instanceof ItemReader) {
                streamIsReader = true;
                composite.register(stream);
                continue;
            }
            step.registerStream(stream);
        }
        TaskExecutor taskExecutor = this.getTaskExecutor();
        if (streamIsReader) {
            boolean concurrent;
            this.chunkMonitor.setItemStream((ItemStream)composite);
            step.registerStream(this.chunkMonitor);
            boolean bl = concurrent = taskExecutor != null && !(taskExecutor instanceof SyncTaskExecutor);
            if (!concurrent) {
                this.chunkMonitor.setItemReader(this.getItemReader());
            } else {
                this.logger.warn((Object)("Synchronous TaskExecutor detected (" + taskExecutor.getClass() + ") with ItemStream reader.  This is probably an error, " + "and may lead to incorrect restart data being stored."));
            }
        }
    }

    @Override
    protected SimpleChunkProvider<T> configureChunkProvider() {
        LimitCheckingItemSkipPolicy readSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, this.getSkippableExceptionClasses(), this.fatalExceptionClasses);
        FaultTolerantChunkProvider chunkProvider = new FaultTolerantChunkProvider(this.getItemReader(), this.getChunkOperations());
        chunkProvider.setSkipPolicy(readSkipPolicy);
        return chunkProvider;
    }

    @Override
    protected SimpleChunkProcessor<T, S> configureChunkProcessor() {
        LimitCheckingItemSkipPolicy writeSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, this.getSkippableExceptionClasses(), this.fatalExceptionClasses);
        BatchRetryTemplate batchRetryTemplate = this.configureRetry();
        FaultTolerantChunkProcessor chunkProcessor = new FaultTolerantChunkProcessor(this.getItemProcessor(), this.getItemWriter(), batchRetryTemplate);
        chunkProcessor.setBuffering(!this.isReaderTransactionalQueue());
        chunkProcessor.setWriteSkipPolicy(writeSkipPolicy);
        chunkProcessor.setProcessSkipPolicy(writeSkipPolicy);
        chunkProcessor.setRollbackClassifier(this.getRollbackClassifier());
        chunkProcessor.setKeyGenerator(this.keyGenerator);
        chunkProcessor.setChunkMonitor(this.chunkMonitor);
        return chunkProcessor;
    }

    private Collection<Class<? extends Throwable>> getSkippableExceptionClasses() {
        HashSet<Class<? extends Throwable>> set = new HashSet<Class<? extends Throwable>>(this.skippableExceptionClasses);
        set.addAll(this.noRollbackExceptionClasses);
        return set;
    }

    private BatchRetryTemplate configureRetry() {
        if (this.retryPolicy == null) {
            SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy(this.retryLimit);
            simpleRetryPolicy.setRetryableExceptionClasses(this.retryableExceptionClasses);
            this.retryPolicy = simpleRetryPolicy;
        }
        RetryPolicy retryPolicyWrapper = this.fatalExceptionAwareProxy(this.retryPolicy);
        BatchRetryTemplate batchRetryTemplate = new BatchRetryTemplate();
        if (this.backOffPolicy != null) {
            batchRetryTemplate.setBackOffPolicy(this.backOffPolicy);
        }
        batchRetryTemplate.setRetryPolicy(retryPolicyWrapper);
        RepeatOperations stepOperations = this.getStepOperations();
        if (stepOperations instanceof RepeatTemplate) {
            SimpleRetryExceptionHandler exceptionHandler = new SimpleRetryExceptionHandler(retryPolicyWrapper, this.getExceptionHandler(), this.fatalExceptionClasses);
            ((RepeatTemplate)stepOperations).setExceptionHandler((ExceptionHandler)exceptionHandler);
        }
        if (this.retryContextCache == null) {
            if (this.cacheCapacity > 0) {
                batchRetryTemplate.setRetryContextCache((RetryContextCache)new MapRetryContextCache(this.cacheCapacity));
            }
        } else {
            batchRetryTemplate.setRetryContextCache(this.retryContextCache);
        }
        if (this.retryListeners != null) {
            batchRetryTemplate.setListeners(this.retryListeners);
        }
        return batchRetryTemplate;
    }

    private RetryPolicy fatalExceptionAwareProxy(final RetryPolicy retryPolicy) {
        final NeverRetryPolicy neverRetryPolicy = new NeverRetryPolicy();
        ExceptionClassifierRetryPolicy retryPolicyWrapper = new ExceptionClassifierRetryPolicy();
        retryPolicyWrapper.setExceptionClassifier((Classifier)new Classifier<Throwable, RetryPolicy>(){

            public RetryPolicy classify(Throwable classifiable) {
                for (Class fatal : FaultTolerantStepFactoryBean.this.fatalExceptionClasses) {
                    if (!fatal.isAssignableFrom(classifiable.getClass())) continue;
                    return neverRetryPolicy;
                }
                return retryPolicy;
            }
        });
        return retryPolicyWrapper;
    }

    private void addFatalExceptionIfMissing(Class ... cls) {
        ArrayList<Class<? extends Throwable>> fatalExceptionList = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> exceptionClass : this.fatalExceptionClasses) {
            fatalExceptionList.add(exceptionClass);
        }
        for (Class fatal : cls) {
            if (fatalExceptionList.contains(fatal)) continue;
            fatalExceptionList.add(fatal);
        }
        this.fatalExceptionClasses = fatalExceptionList;
    }
}

