/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.ChunkElementParser;
import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.StepListenerParser;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractStepParser {
    protected static final String ID_ATTR = "id";
    private static final String PARENT_ATTR = "parent";
    private static final String TASKLET_REF_ATTR = "ref";
    private static final String TASKLET_ELE = "tasklet";
    private static final String CHUNK_ELE = "chunk";
    private static final String LISTENERS_ELE = "listeners";
    private static final String MERGE_ATTR = "merge";
    private static final String TX_ATTRIBUTES_ELE = "transaction-attributes";
    private static final String JOB_REPO_ATTR = "job-repository";
    private static final ChunkElementParser chunkElementParser = new ChunkElementParser();
    private static final StepListenerParser stepListenerParser = new StepListenerParser();

    protected AbstractBeanDefinition parseStep(Element stepElement, ParserContext parserContext, String jobFactoryRef) {
        String isAbstract;
        GenericBeanDefinition bd = new GenericBeanDefinition();
        List taskletElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)TASKLET_ELE);
        if (taskletElements.size() == 1) {
            boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
            this.parseTasklet((Element)taskletElements.get(0), (AbstractBeanDefinition)bd, parserContext, stepUnderspecified);
        } else if (taskletElements.size() > 1) {
            parserContext.getReaderContext().error("The '<tasklet/>' element may not appear more than once in a single <" + stepElement.getNodeName() + "/>.", (Object)stepElement);
        }
        String parentRef = stepElement.getAttribute(PARENT_ATTR);
        if (StringUtils.hasText((String)parentRef)) {
            bd.setParentName(parentRef);
        }
        if (StringUtils.hasText((String)(isAbstract = stepElement.getAttribute("abstract")))) {
            bd.setAbstract(Boolean.valueOf(isAbstract).booleanValue());
        }
        if (StringUtils.hasText((String)jobFactoryRef)) {
            bd.setAttribute("jobParserJobFactoryBeanRef", (Object)jobFactoryRef);
        }
        return bd;
    }

    private void parseTasklet(Element taskletElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", (Object)true);
        String taskletRef = taskletElement.getAttribute(TASKLET_REF_ATTR);
        List chunkElements = DomUtils.getChildElementsByTagName((Element)taskletElement, (String)CHUNK_ELE);
        if (StringUtils.hasText((String)taskletRef)) {
            if (chunkElements.size() > 0) {
                parserContext.getReaderContext().error("The <chunk/> element can't be combined with the 'ref=\"" + taskletRef + "\"' attribute specification for <" + taskletElement.getNodeName() + "/>", (Object)taskletElement);
            }
            this.parseTaskletRef(taskletRef, bd.getPropertyValues());
        } else if (chunkElements.size() == 1) {
            chunkElementParser.parse((Element)chunkElements.get(0), bd, parserContext, stepUnderspecified);
        } else if (!stepUnderspecified) {
            parserContext.getReaderContext().error("Step [" + taskletElement.getAttribute(ID_ATTR) + "] has neither a <" + CHUNK_ELE + "/> element nor a '" + TASKLET_REF_ATTR + "' attribute.", (Object)taskletElement);
        }
        this.setUpBeanDefinitionForTaskletStep(taskletElement, bd, parserContext);
    }

    private void parseTaskletRef(String taskletRef, MutablePropertyValues propertyValues) {
        if (StringUtils.hasText((String)taskletRef)) {
            RuntimeBeanReference taskletBeanRef = new RuntimeBeanReference(taskletRef);
            propertyValues.addPropertyValue(TASKLET_ELE, (Object)taskletBeanRef);
        }
    }

    private void setUpBeanDefinitionForTaskletStep(Element taskletElement, AbstractBeanDefinition bd, ParserContext parserContext) {
        String transactionManagerRef;
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        this.checkStepAttributes(taskletElement, propertyValues);
        String jobRepositoryRef = taskletElement.getAttribute(JOB_REPO_ATTR);
        if (StringUtils.hasText((String)jobRepositoryRef)) {
            RuntimeBeanReference jobRepositoryBeanRef = new RuntimeBeanReference(jobRepositoryRef);
            propertyValues.addPropertyValue("jobRepository", (Object)jobRepositoryBeanRef);
        }
        if (StringUtils.hasText((String)(transactionManagerRef = taskletElement.getAttribute("transaction-manager")))) {
            RuntimeBeanReference transactionManagerBeanRef = new RuntimeBeanReference(transactionManagerRef);
            propertyValues.addPropertyValue("transactionManager", (Object)transactionManagerBeanRef);
        }
        this.handleTransactionAttributesElement(taskletElement, propertyValues, parserContext);
        this.handleListenersElement(taskletElement, propertyValues, parserContext);
        AbstractStepParser.handleExceptionElement(taskletElement, parserContext, propertyValues, "no-rollback-exception-classes", "noRollbackExceptionClasses");
        bd.setRole(1);
        bd.setSource(parserContext.extractSource((Object)taskletElement));
    }

    private void handleTransactionAttributesElement(Element stepElement, MutablePropertyValues propertyValues, ParserContext parserContext) {
        List txAttrElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)TX_ATTRIBUTES_ELE);
        if (txAttrElements.size() == 1) {
            String timeout;
            String isolation;
            Element txAttrElement = (Element)txAttrElements.get(0);
            String propagation = txAttrElement.getAttribute("propagation");
            if (StringUtils.hasText((String)propagation)) {
                propertyValues.addPropertyValue("propagation", (Object)propagation);
            }
            if (StringUtils.hasText((String)(isolation = txAttrElement.getAttribute("isolation")))) {
                propertyValues.addPropertyValue("isolation", (Object)isolation);
            }
            if (StringUtils.hasText((String)(timeout = txAttrElement.getAttribute("timeout")))) {
                propertyValues.addPropertyValue("transactionTimeout", (Object)timeout);
            }
        }
    }

    public static void handleExceptionElement(Element element, ParserContext parserContext, MutablePropertyValues propertyValues, String subElementName, String propertyName) {
        List children = DomUtils.getChildElementsByTagName((Element)element, (String)subElementName);
        if (children.size() == 1) {
            String[] exceptionArray;
            Element child = (Element)children.get(0);
            String exceptions = DomUtils.getTextValue((Element)child);
            if (StringUtils.hasLength((String)exceptions) && (exceptionArray = StringUtils.tokenizeToStringArray((String)exceptions, (String)",\n")).length > 0) {
                ManagedList managedList = new ManagedList();
                managedList.setMergeEnabled(child.hasAttribute(MERGE_ATTR) && Boolean.valueOf(child.getAttribute(MERGE_ATTR)) != false);
                managedList.addAll((Collection)Arrays.asList(exceptionArray));
                propertyValues.addPropertyValue(propertyName, (Object)managedList);
            }
        } else if (children.size() > 1) {
            parserContext.getReaderContext().error("The <" + subElementName + "/> element may not appear more than once in a single <" + element.getNodeName() + "/>.", (Object)element);
        }
    }

    private void checkStepAttributes(Element stepElement, MutablePropertyValues propertyValues) {
        String allowStartIfComplete;
        String startLimit = stepElement.getAttribute("start-limit");
        if (StringUtils.hasText((String)startLimit)) {
            propertyValues.addPropertyValue("startLimit", (Object)startLimit);
        }
        if (StringUtils.hasText((String)(allowStartIfComplete = stepElement.getAttribute("allow-start-if-complete")))) {
            propertyValues.addPropertyValue("allowStartIfComplete", (Object)allowStartIfComplete);
        }
    }

    private void handleListenersElement(Element stepElement, MutablePropertyValues propertyValues, ParserContext parserContext) {
        List listenersElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)LISTENERS_ELE);
        if (listenersElements.size() == 1) {
            Element listenersElement = (Element)listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)stepElement));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList listenerBeans = new ManagedList();
            listenerBeans.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(listenersElement.getAttribute(MERGE_ATTR)) != false);
            List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)"listener");
            if (listenerElements != null) {
                for (Element listenerElement : listenerElements) {
                    listenerBeans.add((Object)stepListenerParser.parse(listenerElement, parserContext));
                }
            }
            propertyValues.addPropertyValue(LISTENERS_ELE, (Object)listenerBeans);
            parserContext.popAndRegisterContainingComponent();
        }
    }
}

