/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.apache.commons.lang.StringUtils;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JobParserJobFactoryBean
implements FactoryBean {
    private String name;
    private Boolean restartable;
    private JobRepository jobRepository;
    private JobExecutionListener[] jobExecutionListeners;
    private JobParametersIncrementer jobParametersIncrementer;
    private Flow flow;

    public JobParserJobFactoryBean(String name) {
        this.name = name;
    }

    public final Object getObject() throws Exception {
        Assert.isTrue((!StringUtils.isBlank((String)this.name) ? 1 : 0) != 0, (String)"The job must have an 'id'.");
        FlowJob flowJob = new FlowJob(this.name);
        if (this.restartable != null) {
            flowJob.setRestartable(this.restartable);
        }
        if (this.jobRepository != null) {
            flowJob.setJobRepository(this.jobRepository);
        }
        if (this.jobExecutionListeners != null) {
            flowJob.setJobExecutionListeners(this.jobExecutionListeners);
        }
        if (this.jobParametersIncrementer != null) {
            flowJob.setJobParametersIncrementer(this.jobParametersIncrementer);
        }
        if (this.flow != null) {
            flowJob.setFlow(this.flow);
        }
        flowJob.afterPropertiesSet();
        return flowJob;
    }

    public void setRestartable(Boolean restartable) {
        this.restartable = restartable;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setJobExecutionListeners(JobExecutionListener[] jobExecutionListeners) {
        this.jobExecutionListeners = jobExecutionListeners;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public Class<FlowJob> getObjectType() {
        return FlowJob.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

