/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.ExitCodeMapper;
import org.springframework.batch.core.launch.support.JvmSystemExiter;
import org.springframework.batch.core.launch.support.SimpleJvmExitCodeMapper;
import org.springframework.batch.core.launch.support.SystemExiter;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CommandLineJobRunner {
    protected static final Log logger = LogFactory.getLog(CommandLineJobRunner.class);
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();
    private JobLauncher launcher;
    private JobLocator jobLocator;
    private SystemExiter systemExiter = new JvmSystemExiter();
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();

    public void setLauncher(JobLauncher launcher) {
        this.launcher = launcher;
    }

    public void setExitCodeMapper(ExitCodeMapper exitCodeMapper) {
        this.exitCodeMapper = exitCodeMapper;
    }

    public void setSystemExiter(SystemExiter systemExitor) {
        this.systemExiter = systemExitor;
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public void exit(int status) {
        this.systemExiter.exit(status);
    }

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    int start(String jobPath, String jobName, String[] parameters) {
        ClassPathXmlApplicationContext context = null;
        try {
            context = new ClassPathXmlApplicationContext(jobPath);
            context.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
            Assert.notNull((Object)this.launcher, (String)"A JobLauncher must be provided.  Please add one to the configuration.");
            Job job = this.jobLocator != null ? this.jobLocator.getJob(jobName) : (Job)context.getBean(jobName);
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(StringUtils.splitArrayElementsIntoProperties((String[])parameters, (String)"="));
            JobExecution jobExecution = this.launcher.run(job, jobParameters);
            int n = this.exitCodeMapper.intValue(jobExecution.getExitStatus().getExitCode());
            return n;
        }
        catch (Throwable e) {
            logger.error((Object)"Job Terminated in error:", e);
            int n = this.exitCodeMapper.intValue(ExitStatus.FAILED.getExitCode());
            return n;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    public static void main(String[] args) {
        CommandLineJobRunner command = new CommandLineJobRunner();
        if (args.length < 2) {
            logger.error((Object)"At least 2 arguments are required: JobPath and JobName.");
            command.exit(1);
        }
        String jobPath = args[0];
        String jobName = args[1];
        String[] parameters = new String[args.length - 2];
        System.arraycopy(args, 2, parameters, 0, args.length - 2);
        int result = command.start(jobPath, jobName, parameters);
        command.exit(result);
    }
}

