/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.Stack;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepSynchronizationManager {
    private static final ThreadLocal<Stack<StepContext>> contextHolder = new ThreadLocal();

    public static StepContext getContext() {
        Stack<StepContext> current = StepSynchronizationManager.getCurrent();
        if (current.isEmpty()) {
            return null;
        }
        return current.peek();
    }

    public static StepContext register(StepExecution stepExecution) {
        if (stepExecution == null) {
            return null;
        }
        StepContext current = StepSynchronizationManager.getContext();
        StepContext context = current != null && current.getStepExecution().equals(stepExecution) ? current : new StepContext(stepExecution);
        StepSynchronizationManager.getCurrent().push(context);
        return context;
    }

    public static void close() {
        StepContext oldSession = StepSynchronizationManager.getContext();
        if (oldSession == null) {
            return;
        }
        StepSynchronizationManager.getCurrent().pop();
    }

    private static Stack<StepContext> getCurrent() {
        if (contextHolder.get() == null) {
            contextHolder.set(new Stack());
        }
        return contextHolder.get();
    }

    public static void release() {
        StepContext context = StepSynchronizationManager.getContext();
        try {
            if (context != null) {
                context.close();
            }
        }
        finally {
            StepSynchronizationManager.close();
        }
    }
}

