/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SkipWrapper;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableProcessException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.support.DefaultRetryState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantChunkProcessor<I, O>
extends SimpleChunkProcessor<I, O> {
    private SkipPolicy itemProcessSkipPolicy = new LimitCheckingItemSkipPolicy(0);
    private SkipPolicy itemWriteSkipPolicy = new LimitCheckingItemSkipPolicy(0);
    private final BatchRetryTemplate batchRetryTemplate;
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean buffering = true;
    private KeyGenerator keyGenerator;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setProcessSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemProcessSkipPolicy = SkipPolicy2;
    }

    public void setWriteSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemWriteSkipPolicy = SkipPolicy2;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setChunkMonitor(ChunkMonitor chunkMonitor) {
        this.chunkMonitor = chunkMonitor;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    public FaultTolerantChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, BatchRetryTemplate batchRetryTemplate) {
        super(itemProcessor, itemWriter);
        this.batchRetryTemplate = batchRetryTemplate;
    }

    @Override
    protected Chunk<O> transform(final StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk outputs = new Chunk();
        Object userData = inputs.getUserData();
        final Chunk cache = userData instanceof Chunk ? (Chunk)userData : null;
        final Chunk.ChunkIterator cacheIterator = cache != null ? cache.iterator() : null;
        final AtomicInteger count = new AtomicInteger(0);
        final Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            RecoveryCallback recoveryCallback;
            final Object item = iterator.next();
            RetryCallback retryCallback = new RetryCallback<O>(){

                public O doWithRetry(RetryContext context) throws Exception {
                    Object output = null;
                    try {
                        Object cached;
                        count.incrementAndGet();
                        Object o = cached = cache != null ? (Object)cacheIterator.next() : null;
                        output = cached != null && count.get() > 1 ? cached : (Object)FaultTolerantChunkProcessor.this.doProcess(item);
                    }
                    catch (Exception e) {
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                            throw e;
                        }
                        if (FaultTolerantChunkProcessor.this.itemProcessSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                            contribution.incrementProcessSkipCount();
                            FaultTolerantChunkProcessor.this.logger.debug((Object)"Skipping after failed process with no rollback", (Throwable)e);
                        }
                        throw new NonSkippableProcessException("Non-skippable exception in processor.  Make sure any exceptions that do not cause a rollback are skippable.", e);
                    }
                    if (output == null) {
                        iterator.remove();
                    }
                    return output;
                }
            };
            Object output = this.batchRetryTemplate.execute(retryCallback, recoveryCallback = new RecoveryCallback<O>(){

                public O recover(RetryContext context) throws Exception {
                    Exception e = context.getLastThrowable();
                    if (FaultTolerantChunkProcessor.this.itemProcessSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                        contribution.incrementProcessSkipCount();
                        iterator.remove(e);
                        FaultTolerantChunkProcessor.this.logger.debug((Object)"Skipping after failed process", (Throwable)e);
                        return null;
                    }
                    throw new RetryException("Non-skippable exception in recoverer while processing", (Throwable)e);
                }
            }, (RetryState)new DefaultRetryState(this.getInputKey(item), this.rollbackClassifier));
            if (output == null) continue;
            outputs.add(output);
        }
        return outputs;
    }

    @Override
    protected void write(final StepContribution contribution, final Chunk<I> inputs, final Chunk<O> outputs) throws Exception {
        RetryCallback<Object> retryCallback = new RetryCallback<Object>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                if (!inputs.isBusy()) {
                    FaultTolerantChunkProcessor.this.chunkMonitor.setChunkSize(inputs.size());
                    FaultTolerantChunkProcessor.this.doWrite(outputs.getItems());
                    contribution.incrementWriteCount(outputs.size());
                } else {
                    FaultTolerantChunkProcessor.this.scan(contribution, inputs, outputs, FaultTolerantChunkProcessor.this.chunkMonitor);
                }
                return null;
            }
        };
        if (!this.buffering) {
            RecoveryCallback<Object> batchRecoveryCallback = new RecoveryCallback<Object>(){

                public Object recover(RetryContext context) throws Exception {
                    Exception e = context.getLastThrowable();
                    if (outputs.size() > 1 && !((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                        throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", (Throwable)e);
                    }
                    Chunk.ChunkIterator inputIterator = inputs.iterator();
                    Chunk.ChunkIterator outputIterator = outputs.iterator();
                    while (outputIterator.hasNext()) {
                        inputIterator.next();
                        outputIterator.next();
                        FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, e, contribution);
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) continue;
                        throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", (Throwable)e);
                    }
                    return null;
                }
            };
            this.batchRetryTemplate.execute(retryCallback, batchRecoveryCallback, BatchRetryTemplate.createState(this.getInputKeys(inputs), this.rollbackClassifier));
        } else {
            RecoveryCallback<Object> recoveryCallback = new RecoveryCallback<Object>(){

                public Object recover(RetryContext context) throws Exception {
                    boolean singleton;
                    Exception le = context.getLastThrowable();
                    boolean bl = singleton = outputs.size() == 1 && outputs.getSkips().isEmpty();
                    if (singleton) {
                        Chunk.ChunkIterator inputIterator = inputs.iterator();
                        Chunk.ChunkIterator outputIterator = outputs.iterator();
                        FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, le, contribution);
                        return null;
                    }
                    inputs.setBusy(true);
                    FaultTolerantChunkProcessor.this.scan(contribution, inputs, outputs, FaultTolerantChunkProcessor.this.chunkMonitor);
                    return null;
                }
            };
            this.batchRetryTemplate.execute(retryCallback, recoveryCallback, (RetryState)new DefaultRetryState(inputs, this.rollbackClassifier));
        }
        this.callSkipListeners(inputs, outputs);
    }

    private void callSkipListeners(Chunk<I> inputs, Chunk<O> outputs) {
        for (SkipWrapper<I> skipWrapper : inputs.getSkips()) {
            I item = skipWrapper.getItem();
            if (item == null) continue;
            Exception e = skipWrapper.getException();
            try {
                this.getListener().onSkipInProcess(item, e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
        for (SkipWrapper<Object> skipWrapper : outputs.getSkips()) {
            Exception e = skipWrapper.getException();
            try {
                this.getListener().onSkipInWrite(skipWrapper.getItem(), e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
        outputs.clearSkips();
        inputs.clearSkips();
    }

    private Object getInputKey(I item) {
        if (this.keyGenerator == null) {
            return item;
        }
        return this.keyGenerator.getKey(item);
    }

    private List<?> getInputKeys(Chunk<I> inputs) {
        if (this.keyGenerator == null) {
            return inputs.getItems();
        }
        ArrayList<Object> keys = new ArrayList<Object>();
        for (I item : inputs.getItems()) {
            keys.add(this.keyGenerator.getKey(item));
        }
        return keys;
    }

    private void checkSkipPolicy(Chunk.ChunkIterator inputIterator, Chunk.ChunkIterator outputIterator, Exception e, StepContribution contribution) {
        if (!this.itemWriteSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
            throw new RetryException("Non-skippable exception in recoverer", (Throwable)e);
        }
        contribution.incrementWriteSkipCount();
        inputIterator.remove();
        outputIterator.remove(e);
        this.logger.debug((Object)"Skipping after failed write", (Throwable)e);
    }

    private void scan(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs, ChunkMonitor chunkMonitor) throws Exception {
        Chunk.ChunkIterator outputIterator;
        Chunk.ChunkIterator inputIterator;
        block4: {
            if (outputs.isEmpty()) {
                inputs.setBusy(false);
                return;
            }
            inputIterator = inputs.iterator();
            outputIterator = outputs.iterator();
            List items = Collections.singletonList(outputIterator.next());
            try {
                this.writeItems(items);
                this.doAfterWrite(items);
                contribution.incrementWriteCount(1);
            }
            catch (Exception e) {
                this.checkSkipPolicy(inputIterator, outputIterator, e, contribution);
                if (!((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) break block4;
                throw e;
            }
        }
        inputIterator.remove();
        outputIterator.remove();
        chunkMonitor.incrementOffset();
        if (outputs.isEmpty()) {
            inputs.setBusy(false);
            chunkMonitor.resetOffset();
        }
    }
}

