/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantChunkProvider<I>
extends SimpleChunkProvider<I> {
    private SkipPolicy skipPolicy = new LimitCheckingItemSkipPolicy(0);

    public FaultTolerantChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        super(itemReader, repeatOperations);
    }

    public void setSkipPolicy(SkipPolicy SkipPolicy2) {
        this.skipPolicy = SkipPolicy2;
    }

    @Override
    protected I read(StepContribution contribution, Chunk<I> chunk) throws Exception {
        while (true) {
            try {
                return this.doRead();
            }
            catch (Exception e) {
                if (this.skipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                    contribution.incrementReadSkipCount();
                    chunk.skip(e);
                    this.logger.debug((Object)"Skipping failed input", (Throwable)e);
                    continue;
                }
                throw new NonSkippableReadException("Non-skippable exception during read", e);
            }
            break;
        }
    }

    @Override
    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
        for (Exception e : chunk.getErrors()) {
            try {
                this.getListener().onSkipInRead(e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
    }
}

