/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.batch.core.launch.support.ExitCodeMapper;
import org.springframework.batch.core.launch.support.JvmSystemExiter;
import org.springframework.batch.core.launch.support.SimpleJvmExitCodeMapper;
import org.springframework.batch.core.launch.support.SystemExiter;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineJobRunner {
    protected static final Log logger = LogFactory.getLog(CommandLineJobRunner.class);
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();
    private JobLauncher launcher;
    private JobLocator jobLocator;
    private static SystemExiter systemExiter = new JvmSystemExiter();
    private static String message = "";
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private JobExplorer jobExplorer;

    public void setLauncher(JobLauncher launcher) {
        this.launcher = launcher;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setExitCodeMapper(ExitCodeMapper exitCodeMapper) {
        this.exitCodeMapper = exitCodeMapper;
    }

    public static void presetSystemExiter(SystemExiter systemExiter) {
        CommandLineJobRunner.systemExiter = systemExiter;
    }

    public static String getErrorMessage() {
        return message;
    }

    public void setSystemExiter(SystemExiter systemExiter) {
        CommandLineJobRunner.systemExiter = systemExiter;
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public void exit(int status) {
        systemExiter.exit(status);
    }

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    int start(String jobPath, String jobName, String[] parameters, Set<String> opts) {
        ClassPathXmlApplicationContext context = null;
        try {
            context = new ClassPathXmlApplicationContext(jobPath);
            context.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
            Assert.state((this.launcher != null ? 1 : 0) != 0, (String)"A JobLauncher must be provided.  Please add one to the configuration.");
            if (opts.contains("-restart") || opts.contains("-next")) {
                Assert.state((this.jobExplorer != null ? 1 : 0) != 0, (String)"A JobExplorer must be provided for a restart or start next operation.  Please add one to the configuration.");
            }
            Job job = this.jobLocator != null ? this.jobLocator.getJob(jobName) : (Job)context.getBean(jobName);
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(StringUtils.splitArrayElementsIntoProperties((String[])parameters, (String)"="));
            Assert.isTrue((parameters == null || parameters.length == 0 || !jobParameters.isEmpty() ? 1 : 0) != 0, (String)("Invalid JobParameters " + Arrays.asList(parameters) + ". If parameters are provided they should be in the form name=value (no whitespace)."));
            if (opts.contains("-restart")) {
                jobParameters = this.getLastFailedJobParameters(jobName);
            } else if (opts.contains("-next")) {
                JobParameters nextParameters = this.getNextJobParameters(job);
                HashMap<String, JobParameter> map = new HashMap<String, JobParameter>(nextParameters.getParameters());
                map.putAll(jobParameters.getParameters());
                jobParameters = new JobParameters(map);
            }
            JobExecution jobExecution = this.launcher.run(job, jobParameters);
            int n = this.exitCodeMapper.intValue(jobExecution.getExitStatus().getExitCode());
            return n;
        }
        catch (Throwable e) {
            String message = "Job Terminated in error: " + e.getMessage();
            logger.error((Object)message, e);
            CommandLineJobRunner.message = message;
            int n = this.exitCodeMapper.intValue(ExitStatus.FAILED.getExitCode());
            return n;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private JobParameters getLastFailedJobParameters(String jobName) throws JobParametersNotFoundException {
        start = 0;
        count = 100;
        lastInstances = this.jobExplorer.getJobInstances(jobName, start, count);
        jobParameters = null;
        if (!lastInstances.isEmpty()) ** GOTO lbl14
        throw new JobParametersNotFoundException("No job instance found for job=" + jobName);
lbl-1000:
        // 2 sources

        {
            for (JobInstance jobInstance : lastInstances) {
                jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty() || !(jobExecution = jobExecutions.get(jobExecutions.size() - 1)).getStatus().isGreaterThan(BatchStatus.STOPPING)) continue;
                jobParameters = jobInstance.getJobParameters();
                break;
            }
            if (jobParameters != null) break;
            lastInstances = this.jobExplorer.getJobInstances(jobName, start += count, count);
lbl14:
            // 2 sources

            ** while (!lastInstances.isEmpty())
        }
lbl15:
        // 2 sources

        if (jobParameters == null) {
            throw new JobParametersNotFoundException("No failed or stopped execution found for job=" + jobName);
        }
        return jobParameters;
    }

    private JobParameters getNextJobParameters(Job job) throws JobParametersNotFoundException {
        JobParameters jobParameters;
        String jobName = job.getName();
        List<JobInstance> lastInstances = this.jobExplorer.getJobInstances(jobName, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        if (incrementer == null) {
            throw new JobParametersNotFoundException("No job parameters incrementer found for job=" + jobName);
        }
        if (lastInstances.isEmpty()) {
            jobParameters = incrementer.getNext(new JobParameters());
            if (jobParameters == null) {
                throw new JobParametersNotFoundException("No bootstrap parameters found from incrementer for job=" + jobName);
            }
        } else {
            jobParameters = incrementer.getNext(lastInstances.get(0).getJobParameters());
        }
        return jobParameters;
    }

    public static void main(String[] args) {
        CommandLineJobRunner command = new CommandLineJobRunner();
        HashSet<String> opts = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        int count = 0;
        String jobPath = null;
        String jobName = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) {
                opts.add(arg);
            } else {
                switch (count) {
                    case 0: {
                        jobPath = arg;
                        break;
                    }
                    case 1: {
                        jobName = arg;
                        break;
                    }
                    default: {
                        params.add(arg);
                    }
                }
                ++count;
            }
            ++n2;
        }
        if (jobPath == null || jobName == null) {
            String message = "At least 2 arguments are required: JobPath and JobName.";
            logger.error((Object)message);
            CommandLineJobRunner.message = message;
            command.exit(1);
        }
        String[] parameters = params.toArray(new String[params.size()]);
        int result = command.start(jobPath, jobName, parameters, opts);
        command.exit(result);
    }
}

