/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.JobParametersConverter;

public class ScheduledJobParametersFactory
implements JobParametersConverter {
    public static final String SCHEDULE_DATE_KEY = "schedule.date";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");

    public JobParameters getJobParameters(Properties props) {
        if (props == null || props.isEmpty()) {
            return new JobParameters();
        }
        JobParametersBuilder propertiesBuilder = new JobParametersBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (entry.getKey().equals(SCHEDULE_DATE_KEY)) {
                Date scheduleDate;
                try {
                    scheduleDate = this.dateFormat.parse(entry.getValue().toString());
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException("Date format is invalid: [" + entry.getValue() + "]");
                }
                propertiesBuilder.addDate(entry.getKey().toString(), scheduleDate);
                continue;
            }
            propertiesBuilder.addString(entry.getKey().toString(), entry.getValue().toString());
        }
        return propertiesBuilder.toJobParameters();
    }

    public Properties getProperties(JobParameters params) {
        if (params == null || params.isEmpty()) {
            return new Properties();
        }
        Map<String, JobParameter> parameters = params.getParameters();
        Properties result = new Properties();
        for (Map.Entry<String, JobParameter> entry : parameters.entrySet()) {
            String key = entry.getKey();
            JobParameter jobParameter = entry.getValue();
            if (key.equals(SCHEDULE_DATE_KEY)) {
                result.setProperty(key, this.dateFormat.format(jobParameter.getValue()));
                continue;
            }
            result.setProperty(key, "" + jobParameter.getValue());
        }
        return result;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }
}

