/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.batch.core.listener.ListenerMetaData;
import org.springframework.batch.core.listener.MethodInvokerMethodInterceptor;
import org.springframework.batch.support.MethodInvoker;
import org.springframework.batch.support.MethodInvokerUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerFactoryBean
implements FactoryBean,
InitializingBean {
    private Object delegate;
    private Map<String, String> metaDataMap;

    public Object getObject() {
        boolean bl;
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, String>();
        }
        ListenerMetaData[] listenerMetaDataArray = this.getMetaDataValues();
        int n = listenerMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerMetaData metaData = listenerMetaDataArray[n2];
            if (!this.metaDataMap.containsKey(metaData.getPropertyName())) {
                this.metaDataMap.put(metaData.getPropertyName(), null);
            }
            ++n2;
        }
        HashSet listenerInterfaces = new HashSet();
        HashMap<String, Set<MethodInvoker>> invokerMap = new HashMap<String, Set<MethodInvoker>>();
        for (Map.Entry entry : this.metaDataMap.entrySet()) {
            ListenerMetaData metaData = this.getMetaDataFromPropertyName((String)entry.getKey());
            NullIgnoringSet<MethodInvoker> invokers = new NullIgnoringSet<MethodInvoker>();
            invokers.add(this.getMethodInvokerByName((String)entry.getValue(), this.delegate, metaData.getParamTypes()));
            invokers.add(MethodInvokerUtils.getMethodInvokerForInterface(metaData.getListenerInterface(), (String)metaData.getMethodName(), (Object)this.delegate, (Class[])metaData.getParamTypes()));
            invokers.add(MethodInvokerUtils.getMethodInvokerByAnnotation(metaData.getAnnotation(), (Object)this.delegate, (Class[])metaData.getParamTypes()));
            if (invokers.isEmpty()) continue;
            invokerMap.put(metaData.getMethodName(), invokers);
            listenerInterfaces.add(metaData.getListenerInterface());
        }
        if (listenerInterfaces.isEmpty()) {
            listenerInterfaces.add(this.getDefaultListenerClass());
        }
        boolean bl2 = false;
        if (this.delegate instanceof Ordered) {
            bl = true;
            listenerInterfaces.add(Ordered.class);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.delegate instanceof Advised) {
            proxyFactory.setTargetSource(((Advised)this.delegate).getTargetSource());
        } else {
            proxyFactory.setTarget(this.delegate);
        }
        proxyFactory.setInterfaces(listenerInterfaces.toArray(new Class[0]));
        proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInvokerMethodInterceptor(invokerMap, bl)));
        return proxyFactory.getProxy();
    }

    protected abstract ListenerMetaData getMetaDataFromPropertyName(String var1);

    protected abstract ListenerMetaData[] getMetaDataValues();

    protected abstract Class<?> getDefaultListenerClass();

    protected MethodInvoker getMethodInvokerByName(String methodName, Object candidate, Class<?> ... params) {
        if (methodName != null) {
            return MethodInvokerUtils.getMethodInvokerByName((Object)candidate, (String)methodName, (boolean)false, (Class[])params);
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void setMetaDataMap(Map<String, String> metaDataMap) {
        this.metaDataMap = metaDataMap;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"Delegate must not be null");
    }

    public static boolean isListener(Object target, Class<?> listenerType, ListenerMetaData[] metaDataValues) {
        TargetSource targetSource;
        if (listenerType.isInstance(target)) {
            return true;
        }
        if (target instanceof Advised && (targetSource = ((Advised)target).getTargetSource()) != null && targetSource.getTargetClass() != null && listenerType.isAssignableFrom(targetSource.getTargetClass())) {
            return true;
        }
        ListenerMetaData[] listenerMetaDataArray = metaDataValues;
        int n = metaDataValues.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerMetaData metaData = listenerMetaDataArray[n2];
            if (MethodInvokerUtils.getMethodInvokerByAnnotation(metaData.getAnnotation(), (Object)target) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NullIgnoringSet<E>
    extends HashSet<E> {
        protected NullIgnoringSet() {
        }

        @Override
        public boolean add(E e) {
            if (e == null) {
                return false;
            }
            return super.add(e);
        }
    }
}

