/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.annotation.AfterJob;
import org.springframework.batch.core.annotation.BeforeJob;
import org.springframework.batch.core.listener.ListenerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JobListenerMetaData implements ListenerMetaData
{
    BEFORE_JOB("beforeJob", "before-job-method", BeforeJob.class),
    AFTER_JOB("afterJob", "after-job-method", AfterJob.class);

    private final String methodName;
    private final String propertyName;
    private final Class<? extends Annotation> annotation;
    private static final Map<String, JobListenerMetaData> propertyMap;

    static {
        propertyMap = new HashMap<String, JobListenerMetaData>();
        JobListenerMetaData[] jobListenerMetaDataArray = JobListenerMetaData.values();
        int n = jobListenerMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            JobListenerMetaData metaData = jobListenerMetaDataArray[n2];
            propertyMap.put(metaData.getPropertyName(), metaData);
            ++n2;
        }
    }

    private JobListenerMetaData(String methodName, String propertyName, Class<? extends Annotation> annotation) {
        this.methodName = methodName;
        this.propertyName = propertyName;
        this.annotation = annotation;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    @Override
    public Class<?> getListenerInterface() {
        return JobExecutionListener.class;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Class<?>[] getParamTypes() {
        return new Class[]{JobExecution.class};
    }

    public static JobListenerMetaData fromPropertyName(String propertyName) {
        return propertyMap.get(propertyName);
    }
}

